package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * ListTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListTestRunRequest 2014-05-06 16:23:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestRunRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public ListTestRunRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the test cycle identifier where to fetch the test suites.
   *
   * @param artifactId the given test artifact identifier.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier where to fetch the test suites.
   *
   * @param artifactId the given artifact identifier to set.
   * @return the list test-run request instance.
   */
  public ListTestRunRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public ListTestRunRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append('}');
    return sb.toString();
  }
}
