package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestSuiteRequest 2015-05-29 15:49:30z dzungvnguyen $
 * @since 1.0
 */
public class GetTestSuiteRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testSuiteId;

  //~ class members ===========================================================
  /**
   * @return the given test-suite identifier.
   */
  public Long getTestSuiteId() {
    return testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier.
   */
  public void setTestSuiteId(Long testSuiteId) {
    this.testSuiteId = testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier.
   * @return the get test-suite request instance.
   */
  public GetTestSuiteRequest withTestSuiteId(Long testSuiteId) {
    setTestSuiteId(testSuiteId);
    return this;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier.
   * @return the get test-suite request instance.
   */
  public GetTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testSuiteId=").append(testSuiteId);
    sb.append('}');
    return sb.toString();
  }
}
