package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestCycleRequest 2015-05-28 11:06:30z dzungvnguyen $
 * @since 1.0
 */
public class GetTestCycleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCycleId;
  private boolean includeDescendants;

  //~ class members ===========================================================
  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public GetTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the get test cycle identifier.
   */
  public Long getTestCycleId() {
    return testCycleId;
  }

  /**
   * Sets the test cycle identifier.
   *
   * @param testCycleId the given test cycle identifier to set.
   */
  public void setTestCycleId(Long testCycleId) {
    this.testCycleId = testCycleId;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier to set.
   * @return the {@link GetTestCycleRequest} instance.
   */
  public GetTestCycleRequest withTestCycleId(Long testCycleId) {
    setTestCycleId(testCycleId);
    return this;
  }

  /**
   * @return if we want to fetch test-cycle descendants.
   */
  public boolean isIncludeDescendants() {
    return includeDescendants;
  }

  /**
   * Sets the test-cycle descendant flag.
   *
   * @param includeDescendants the given test-cycle descendant flag to set.
   */
  public void setIncludeDescendants(boolean includeDescendants) {
    this.includeDescendants = includeDescendants;
  }

  /**
   * Sets the test-cycle descendant flag.
   *
   * @param includeDescendants the given test-cycle descendant flag to set.
   * @return {@link GetTestCycleRequest} instance.
   */
  public GetTestCycleRequest withIncludeDescendants(boolean includeDescendants) {
    setIncludeDescendants(includeDescendants);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCycleId=").append(testCycleId);
    sb.append(", includeDescendants=").append(includeDescendants);
    sb.append('}');
    return sb.toString();
  }
}
