package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * DeleteTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestRunRequest 2015-05-31 23:39:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteTestRunRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testRunId;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   * @return the current {@link DeleteTestRunRequest} object.
   */
  public DeleteTestRunRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test run id.
   */
  public Long getTestRunId() {
    return testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   */
  public void setTestRunId(Long testRunId) {
    this.testRunId = testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   * @return the current {@link DeleteTestRunRequest} object.
   */
  public DeleteTestRunRequest withTestRunId(Long testRunId) {
    setTestRunId(testRunId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testRunId=").append(testRunId);
    sb.append('}');
    return sb.toString();
  }
}
