package org.qas.qtest.api.services.execution.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.api.ApiServiceRequest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AutomationTestLogsRequest extends ApiServiceRequest {

  /*path*/
  @JsonIgnore
  private Long projectId;
  @JsonIgnore
  private Long testRunId = 0L;
  /*param*/
  @JsonIgnore
  private AutomationType automationType = AutomationType.AUTOMATION;
  @JsonIgnore
  private boolean escapeXml = false;
  @JsonIgnore
  private Long userId;
  /*body*/
  @JsonProperty("test_suite")
  private String testSuite;
  @JsonProperty("parent_module")
  private String parentModule;
  @JsonProperty("test_logs")
  private List<AutomationTestLog> testLogResources;
  @JsonProperty("execution_date")
  private Date executionDate;
  @JsonProperty("test_cycle")
  private String testCycle;
  @JsonProperty("escapeAutomationContent")
  private boolean escapeAutomationContent = false;
  @JsonProperty("skipCreatingAutomationModule")
  private boolean skipCreatingAutomationModule = false;

  public AutomationTestLogsRequest() {
  }

  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public AutomationTestLogsRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  public Long getTestRunId() {
    return testRunId;
  }

  public AutomationType getAutomationType() {
    return automationType;
  }

  public boolean isEscapeXml() {
    return escapeXml;
  }

  public void setEscapeXml(boolean escapeXml) {
    this.escapeXml = escapeXml;
  }

  public AutomationTestLogsRequest withEscapeXml(boolean escapeXml) {
    setEscapeXml(escapeXml);
    return this;
  }

  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public AutomationTestLogsRequest withUserId(Long userId) {
    setUserId(userId);
    return this;
  }

  public String getTestSuite() {
    return testSuite;
  }

  public void setTestSuite(String testSuite) {
    this.testSuite = testSuite;
  }

  public AutomationTestLogsRequest withTestSuite(String testSuite) {
    setTestSuite(testSuite);
    return this;
  }

  public String getParentModule() {
    return parentModule;
  }

  public void setParentModule(String parentModule) {
    this.parentModule = parentModule;
  }

  public AutomationTestLogsRequest withParentModule(String parentModule) {
    setParentModule(parentModule);
    return this;
  }

  public List<AutomationTestLog> getTestLogResources() {
    return testLogResources;
  }

  public void setTestLogResources(
      List<AutomationTestLog> testLogResources) {
    this.testLogResources = testLogResources;
  }

  public AutomationTestLogsRequest withTestLogResources(List<AutomationTestLog> testLogResources) {
    setTestLogResources(testLogResources);
    return this;
  }

  public AutomationTestLogsRequest addTestLogResource(AutomationTestLog testLogResource) {
    if (null == this.testLogResources) {
      this.testLogResources = new ArrayList<>();
    }
    testLogResources.add(testLogResource);
    return this;
  }

  public Date getExecutionDate() {
    return executionDate;
  }

  public void setExecutionDate(Date executionDate) {
    this.executionDate = executionDate;
  }

  public AutomationTestLogsRequest withExecutionDate(Date executionDate) {
    setExecutionDate(executionDate);
    return this;
  }

  public String getTestCycle() {
    return testCycle;
  }

  public void setTestCycle(String testCycle) {
    this.testCycle = testCycle;
  }

  public AutomationTestLogsRequest withTestCycle(String testCycle) {
    setTestCycle(testCycle);
    return this;
  }

  public boolean isEscapeAutomationContent() {
    return escapeAutomationContent;
  }

  public void setEscapeAutomationContent(boolean escapeAutomationContent) {
    this.escapeAutomationContent = escapeAutomationContent;
  }

  public AutomationTestLogsRequest withEscapeAutomationContent(boolean escapeAutomationContent) {
    setEscapeAutomationContent(escapeAutomationContent);
    return this;
  }

  public boolean isSkipCreatingAutomationModule() {
    return skipCreatingAutomationModule;
  }

  public void setSkipCreatingAutomationModule(boolean skipCreatingAutomationModule) {
    this.skipCreatingAutomationModule = skipCreatingAutomationModule;
  }

  public AutomationTestLogsRequest withSkipCreatingAutomationModule(boolean skipCreatingAutomationModule) {
    setSkipCreatingAutomationModule(skipCreatingAutomationModule);
    return this;
  }

}
