package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.design.model.CreateTestStepRequest;

/**
 * CreateTestStepRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestStepRequestMarshaller 2014-04-05 11:59:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateTestStepRequestMarshaller extends AbstractMarshaller<Request, CreateTestStepRequest> {

  @Override
  protected void validateRequest(CreateTestStepRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    // validate project id.
    if (in.getProjectId() == null
      || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }
    // validate test case id.
    if (in.getTestCaseId() == null
      || in.getTestCaseId() <= 0) {
      throw new AuthClientException("Invalid test case id passed to marshall(...)");
    }
    // validate test step instance.
    if (in.getTestStep() == null) {
      throw new AuthClientException("Invalid test step instance passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, CreateTestStepRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "TestDesignService";
  }

  @Override
  protected String getActionName() {
    return "CreateTestStep";
  }

  @Override
  protected String getContent(CreateTestStepRequest in) throws Exception {
    return JsonMapper.toJson(in.getTestStep());
  }

  @Override
  protected StringBuilder getResourcePath(CreateTestStepRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/test-cases/")
      .append(in.getTestCaseId())
      .append("/test-steps");
  }
}
