package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.CreateAutomationTestCaseRequest;

/**
 * CreateAutomationTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateAutomationTestCaseRequestMarshaller 2015-03-14 22:53:30z dungnguyen $
 * @since 1.0
 */
public final class CreateAutomationTestCaseRequestMarshaller
  extends AbstractTestCaseRequestMarshaller<CreateAutomationTestCaseRequest> {
  //~ class members =====================================================================
  @Override
  public Request marshall(CreateAutomationTestCaseRequest automationTestCaseRequest) throws Exception {
    // validate request.
    automationTestCaseRequest = ApiPreconditions.notNull(automationTestCaseRequest);
    validateProjectId(automationTestCaseRequest.getProjectId());
    ApiPreconditions.notNull(
      automationTestCaseRequest.getAutomationTestCase(),
      "Invalid test-case instance passed to marshall(...)"
    );

    // validate request.
    Request request = createJsonRequest(automationTestCaseRequest, "CreateAutomationTestCase", HttpMethod.POST);

    // build the path resource.
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(automationTestCaseRequest.getProjectId()));
    pathBuilder.append("/auto-test-cases");
    request.setResourcePath(pathBuilder.toString());

    // set body request.
    request.setContent(new StringInputStream(JsonMapper.toJson(automationTestCaseRequest.getAutomationTestCase())));
    return request;
  }

}
