package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * MoveTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestCaseRequest 2015-06-03 17:40:30z dzungvnguyen $
 * @since 1.0
 */
public class MoveTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCaseId;
  private Long moduleId;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public MoveTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public MoveTestCaseRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return the module identifier.
   */
  public Long getModuleId() {
    return moduleId;
  }

  /**
   * Sets module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setModuleId(Long moduleId) {
    this.moduleId = moduleId;
  }

  /**
   * Sets module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return this
   */
  public MoveTestCaseRequest withModuleId(Long moduleId) {
    setModuleId(moduleId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("MoveTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", moduleId=").append(moduleId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append('}');
    return sb.toString();
  }
}
