package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * ApproveTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id ApproveTestCaseRequest 2016-06-22 22:12:30z dzungvnguyen $
 * @since 1.0
 */
public class ApproveTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCaseId;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public ApproveTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public ApproveTestCaseRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ApproveTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append('}');
    return sb.toString();
  }
}
