package org.qas.qtest.api.services.design;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.services.design.model.*;
import org.qas.qtest.api.services.project.model.GetFieldsRequest;

import java.util.List;

/**
 * TestDesignService
 *
 * @author Dzung Nguyen
 * @version $Id TestDesignService 2014-03-28 06:32:30z dungvnguyen $
 * @since 1.0
 */
public interface TestDesignService extends QTestService {
  /**
   * Returns the list of testcase custom fields.
   *
   * @param getTestCaseFieldsRequest the given {@link GetTestCaseFieldsRequest get testcase field request}
   *                                 information
   * @return the list of testcase custom fields
   * @throws AuthServiceException if an error occurs during getting testcase fields.
   * @deprecated replace with {@link org.qas.qtest.api.services.project.ProjectService#getFields(GetFieldsRequest)}
   */
  @Deprecated
  List<Field> getTestCaseFields(GetTestCaseFieldsRequest getTestCaseFieldsRequest) throws AuthServiceException;

  /**
   * Lists all test case in the current project.
   *
   * @param listTestCaseRequest the given {@link ListTestCaseRequest list test case request}
   *                            object.
   * @return the list of {@link TestCase test case} object.
   * @throws AuthServiceException if an error occurs during listing all test case objects.
   */
  List<TestCase> listTestCase(ListTestCaseRequest listTestCaseRequest) throws AuthServiceException;

  /**
   * Gets {@link TestCase} from the given {@link GetTestCaseRequest test case request}
   *
   * @param testCaseRequest the given {@link GetTestCaseRequest test case request}
   * @return the {@link TestCase} instance.
   * @throws AuthServiceException if an error occurs during getting the test case.
   */
  TestCase getTestCase(GetTestCaseRequest testCaseRequest) throws AuthServiceException;

  /**
   * Creates testcase comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest create testcase comment request}
   *                                   instance.
   * @return the given {@link TestCase} instance.
   * @throws AuthServiceException if an error occurs during adding comment.
   */
  TestCase addComment(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException;

  /**
   * Gets {@link TestStep} from the given {@link GetTestStepRequest test step request}
   *
   * @param testStepRequest the given {@link GetTestStepRequest test step request}
   * @return the {@link TestStep} instance.
   * @throws AuthServiceException if an error occurs during getting the test case.
   */
  TestStep getTestStep(GetTestStepRequest testStepRequest) throws AuthServiceException;

  /**
   * Gets list of {@link TestStep} from the given {@link ListTestStepRequest test step request}
   *
   * @param testStepRequest the given {@link ListTestStepRequest test step request}
   * @return the list of {@link TestStep} instance.
   * @throws AuthServiceException if an error occurs during getting the test step.
   */
  List<TestStep> listTestStep(ListTestStepRequest testStepRequest) throws AuthServiceException;

  /**
   * Creates the {@link TestCase test case} from the given
   * {@link CreateTestCaseRequest create test case request}
   *
   * @param testCaseRequest the given {@link CreateTestCaseRequest create test case request}
   *                        instance.
   * @return the {@link TestCase test case} instance.
   * @throws AuthServiceException if an error occurs during creating test case instance.
   */
  TestCase createTestCase(CreateTestCaseRequest testCaseRequest) throws AuthServiceException;

  /**
   * Creates the {@link CreateAutomationTestCaseRequest automation test case} from the given
   * {@link CreateTestCaseRequest create automation test case request}
   *
   * @param automationTestCaseRequest the given {@link CreateAutomationTestCaseRequest create automation test case request}
   *                        instance.
   * @return the {@link AutomationTestCase automation test case} instance.
   * @throws AuthServiceException if an error occurs during creating test case instance.
   */
  AutomationTestCase createAutomationTestCase(CreateAutomationTestCaseRequest automationTestCaseRequest) throws AuthServiceException;
  
  /**
   * Creates the {@link TestStep test step} from the given {@link CreateTestStepRequest create test step request}
   *
   * @param testStepRequest the given {@link CreateTestStepRequest create test step request}
   *                        instance.
   * @return the {@link TestStep test step} instance.
   * @throws AuthServiceException if an error occurs during creating test step instance.
   */
  TestStep createTestStep(CreateTestStepRequest testStepRequest) throws AuthServiceException;

  /**
   * Delete the test case from the given delete test-case request.
   *
   * @param testCaseRequest the given test-case request.
   * @throws AuthServiceException if an error occurs during deleting test-case.
   */
  void deleteTestCase(DeleteTestCaseRequest testCaseRequest) throws AuthServiceException;

  /**
   * Update test-case.
   *
   * @param testCaseRequest the given update test-case request.
   * @return the test-case instance.
   * @throws AuthServiceException if an error occurs during updating test-case.
   */
  TestCase updateTestCase(UpdateTestCaseRequest testCaseRequest) throws AuthServiceException;

  /**
   * Move test-case.
   *
   * @param testCaseRequest the given move test-case request.
   * @return the test-case instance.
   * @throws AuthServiceException if an error occurs during moving test-case.
   */
  TestCase moveTestCase(MoveTestCaseRequest testCaseRequest) throws AuthServiceException;

  /**
   * Approve testcase.
   *
   * @param testCaseRequest the given approve testcase request.
   * @return the {@link TestCase} instance.
   * @throws AuthServiceException if an error occurs during approving testcase.
   */
  TestCase approveTestCase(ApproveTestCaseRequest testCaseRequest) throws AuthServiceException;
}
