package org.qas.qtest.api.services.defect.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.defect.model.CreateDefectRequest;

/**
 * CreateDefectRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateDefectRequestMarshaller 2014-07-16 16:33:30z dungvnguyen $
 * @since 1.0
 */
public class CreateDefectRequestMarshaller extends AbstractMarshaller<Request, CreateDefectRequest> {

  @Override
  protected void validateRequest(CreateDefectRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to call(...)");
    }

    if (in.getDefect() == null) {
      throw new AuthClientException("Invalid defect passed to call(...)");
    }
  }

  @Override
  protected void build(Request request, CreateDefectRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "DefectService";
  }

  @Override
  protected String getActionName() {
    return "CreateDefect";
  }

  @Override
  protected String getContent(CreateDefectRequest in) throws Exception {
    return JsonMapper.toJson(in.getDefect());
  }

  @Override
  protected StringBuilder getResourcePath(CreateDefectRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/defects");
  }
}
