package org.qas.qtest.api.services.client.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.client.model.Client;

/**
 * ClientJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ClientJsonUnmarshaller 2014-11-11 14:19:30z dungvnguyen $
 * @since 1.0
 */
public final class ClientJsonUnmarshaller extends AbstractUnmarshaller<Client, JsonUnmarshallerContext> {
  //~ class instance ==========================================================
  private static ClientJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ClientJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ClientJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public Client parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Client.class);
  }
}
