package org.qas.qtest.api.services.client.model;

import org.qas.api.ApiServiceRequest;

/**
 * SetSessionUrlRequest
 *
 * @author Dzung Nguyen
 * @version $Id SetSessionUrlRequest 2015-01-13 14:00:30z dzungvnguyen $
 * @since 1.0
 */
public final class SetSessionUrlRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private String sessionUrl;

  //~ class members ===========================================================
  /**
   * @return the session URL.
   */
  public String getSessionUrl() {
    return sessionUrl;
  }

  /**
   * Sets the session URL.
   *
   * @param sessionUrl the given session URL to set.
   */
  public void setSessionUrl(String sessionUrl) {
    this.sessionUrl = sessionUrl;
  }

  /**
   * Sets the session URL.
   *
   * @param sessionUrl the given session URL to set.
   * @return the {@link SetSessionUrlRequest session URL request} instance.
   */
  public SetSessionUrlRequest withSessionUrl(String sessionUrl) {
    setSessionUrl(sessionUrl);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("SetSessionUrlRequest{\n");
    sb.append("\tsessionUrl: ").append(sessionUrl).append("\n");
    sb.append('}');

    return sb.toString();
  }
}
