package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenStatusResponse;

/**
 * OAuthTokenStatusResponseJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenStatusResponseJsonUnmarshaller 2016-11-29 06:38:30z dzungvnguyen $
 * @since 1.0
 */
public final class OAuthTokenStatusResponseJsonUnmarshaller extends AbstractUnmarshaller<OAuthTokenStatusResponse, JsonUnmarshallerContext> {
  //~ class instance ==========================================================
  private static OAuthTokenStatusResponseJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static OAuthTokenStatusResponseJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new OAuthTokenStatusResponseJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public OAuthTokenStatusResponse parse(String data) throws Exception {
    return JsonMapper.parseJson(data, OAuthTokenStatusResponse.class);
  }
}
