package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.internal.util.google.net.HttpHeaders;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenStatusRequest;

import static org.qas.qtest.api.services.authenticate.model.transform.OAuthAuthenticateRequestMarshaller.normalizeToken;

/**
 * OAuthTokenStatusRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenStatusRequestMarshaller 2016-11-29 06:31:30z dzungvnguyen $
 * @since 1.0
 */
public class OAuthTokenStatusRequestMarshaller extends AbstractMarshaller<Request, OAuthTokenStatusRequest> {

  @Override
  protected void validateRequest(OAuthTokenStatusRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call (...)");
    }
  }

  @Override
  protected void build(Request request, OAuthTokenStatusRequest in) {
    super.build(request, in);
    request.setHeader(HttpHeaders.AUTHORIZATION, normalizeToken(in.getToken(), "Bearer"));
  }

  @Override
  protected String getServiceName() {
    return "AuthenticateService";
  }

  @Override
  protected String getActionName() {
    return "TokenStatus";
  }

  @Override
  protected String getContent(OAuthTokenStatusRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(OAuthTokenStatusRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/oauth/status");
  }
}
