package org.qas.qtest.api.services.authenticate.model;

import org.qas.api.ApiServiceRequest;

/**
 * OAuthTokenStatusRequest
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenStatusRequest 2016-11-29 06:27:30z dzungvnguyen $
 * @since 1.0
 */
public final class OAuthTokenStatusRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private String token;

  //~ class members ===========================================================
  /**
   * @return the OAuth token.
   */
  public String getToken() {
    return token;
  }

  /**
   * Sets the OAuth access token.
   *
   * @param token the given OAuth access token to set.
   */
  public void setToken(String token) {
    this.token = token;
  }

  /**
   * Sets the OAuth access token and return current instance.
   *
   * @param token the given OAuth access token to set.
   * @return current instance.
   */
  public OAuthTokenStatusRequest withToken(String token) {
    setToken(token);
    return this;
  }
}
