package org.qas.qtest.api.services.authenticate.model;

import org.qas.api.ApiServiceRequest;

/**
 * AuthenticateRequest
 *
 * @author Dzung Nguyen
 * @version $Id AuthenticateRequest 2014-07-09 10:15:30z dungvnguyen $
 * @since 1.0
 */
public class AuthenticateRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private String username;
  private String password;

  //~ class members ===========================================================
  /**
   * @return the authenticate login name.
   */
  public String getUsername() {
    return this.username;
  }

  /**
   * Sets the authenticate login name.
   *
   * @param username the given authenticate login name to set.
   */
  public void setUsername(String username) {
    this.username = username;
  }

  /**
   * Sets the authenticate login name and return the current authenticate instance.
   *
   * @param username the given authenticate login name to set.
   * @return the current authenticate instance.
   */
  public AuthenticateRequest withUsername(String username) {
    this.setUsername(username);
    return this;
  }

  /**
   * @return the authenticate password.
   */
  public String getPassword() {
    return this.password;
  }

  /**
   * Sets the authenticate password.
   *
   * @param password the given authenticate password to set.
   */
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * Sets the authenticate password and return the authenticate instance.
   *
   * @param password the given authenticate password to set.
   * @return the current authenticate instance.
   */
  public AuthenticateRequest withPassword(String password) {
    this.setPassword(password);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("AuthenticateRequest{\n");

    sb.append("\tusername: ").append(username).append(",\n");
    sb.append("\tpassword: XXXXXXXXXX").append("\n");
    sb.append('}');

    return sb.toString();
  }
}
