package org.qas.qtest.api.internal.util;

import org.qas.api.AuthClientException;

/**
 * ApiPreconditions
 *
 * @author Dzung Nguyen
 * @version $Id ApiPreconditions 2015-05-28 16:52:30z dzungvnguyen $
 * @since 1.0
 */
public final class ApiPreconditions {
  //~ class members ===========================================================
  private ApiPreconditions() {
    throw new AssertionError("Can't create instance from utilities class.");
  }

  /**
   * Validate the given must not be null.
   *
   * @param input the given input.
   * @return the input value if passed validation.
   * @throws AuthClientException if an error occurs during validate.
   */
  public static <V> V notNull(V input) throws AuthClientException {
    checkArgument(input != null);
    return input;
  }

  /**
   * Validate the given must not be null.
   *
   * @param input the given input.
   * @param message the given exception message.
   * @return the input value if passed validation.
   * @throws AuthClientException if an error occurs during validate.
   */
  public static <V> V notNull(V input, String message) throws AuthClientException {
    checkArgument(input != null, message);
    return input;
  }

  /**
   * Check the given expression.
   *
   * @param expression the given expression to validate.
   */
  public static void checkArgument(boolean expression) {
    if (!expression) throw new AuthClientException("Invalid argument passed to marshall(...)");
  }

  /**
   * Checks the given argument.
   *
   * @param expression the given expression to validate.
   * @param message the given message.
   */
  public static void checkArgument(boolean expression, String message) {
    if (!expression) throw new AuthClientException(message);
  }
}
