package org.qas.qtest.api.internal.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.internal.model.Field;

import java.util.List;

/**
 * ListFieldJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListFieldJsonUnmarshaller 2014-05-19 11:48:30z dungvnguyen $
 * @since 1.0
 */
public class ListFieldJsonUnmarshaller extends AbstractUnmarshaller<List<Field>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListFieldJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListFieldJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ListFieldJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public List<Field> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<Field>>() {
    });
  }
}
