package org.qas.qtest.api.internal.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.internal.model.Field;

/**
 * FieldJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id FieldJsonUnmarshaller 2014-05-18 19:42:30z dungvnguyen $
 * @since 1.0
 */
public class FieldJsonUnmarshaller extends AbstractUnmarshaller<Field, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static FieldJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static FieldJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new FieldJsonUnmarshaller();
    }
    return instance;
  }

  @Override
  public Field parse(String data) throws Exception {
    return JsonMapper.fromJson(data, Field.class);
  }
}
