package org.qas.qtest.api.internal.model;

/**
 * DataType
 *
 * @author Dzung Nguyen
 * @version $Id DataType 2014-07-10 23:52:30z dungvnguyen $
 * @since 1.0
 */
public enum DataType {
  Unknown(-1, "Unknown"),
  TextBox(1, "Text box"),
  TextArea(2, "Text area"),
  List(3, "List"),
  Date(4, "Date"),
  UserList(5, "User list"),
  Editor(6, "Editor"),
  Number(7, "Number"),
  Checklist(8, "Check list"),
  DateTime(9, "Date time"),
  Id(11, "Identifier"),
  Url(12, "URL"),
  ColoredList(15, "ColoredList");

  //~ class properties ========================================================
  private final int id;
  private final String description;

  //~ class members ===========================================================

  /**
   * Create the data type from the given data type identifier.
   *
   * @param id          the given data type identifier.
   * @param description the given data type description.
   */
  DataType(int id, String description) {
    this.id = id;
    this.description = description;
  }

  /**
   * @return the data type identifier.
   */
  public int getId() {
    return id;
  }

  /**
   * @return the data type description.
   */
  public String getDescription() {
    return this.description;
  }

  /**
   * @param dataType dataType
   * @return the matched data type.
   */
  public static DataType matches(String dataType) {
    if ("textbox".equals(dataType.toLowerCase())) return TextBox;
    if ("textarea".equals(dataType.toLowerCase())) return TextArea;
    if ("list".equals(dataType.toLowerCase())) return List;
    if ("date".equals(dataType.toLowerCase())) return Date;
    if ("userlist".equals(dataType.toLowerCase())) return UserList;
    if ("editor".equals(dataType.toLowerCase())) return Editor;
    if ("number".equals(dataType.toLowerCase())) return Number;
    if ("checklist".equals(dataType.toLowerCase())) return Checklist;
    if ("datetime".equals(dataType.toLowerCase())) return DateTime;
    if ("id".equals(dataType.toLowerCase())) return Id;
    if ("url".equals(dataType.toLowerCase())) return Url;
    if ("coloredlist".equals(dataType.toLowerCase())) return ColoredList;
    return Unknown;
  }

  /**
   * @param dataTypeId dataTypeId
   * @return the matched data type.
   */
  public static DataType matches(int dataTypeId) {
    if (dataTypeId == TextBox.id) return TextBox;
    if (dataTypeId == TextArea.id) return TextArea;
    if (dataTypeId == List.id) return List;
    if (dataTypeId == Date.id) return Date;
    if (dataTypeId == UserList.id) return UserList;
    if (dataTypeId == Editor.id) return Editor;
    if (dataTypeId == Number.id) return Number;
    if (dataTypeId == Checklist.id) return Checklist;
    if (dataTypeId == DateTime.id) return DateTime;
    if (dataTypeId == Id.id) return Id;
    if (dataTypeId == Url.id) return Url;
    if (dataTypeId == ColoredList.id) return ColoredList;
    return Unknown;
  }
}
