package org.qas.qtest.api.internal.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateObjectCommentRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateObjectCommentRequest 2014-09-11 15:54:30z dungvnguyen $
 * @since 1.0
 */
public class CreateObjectCommentRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long objectId;
  private ObjectType objectType;
  private String comment;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier and return current instance.
   *
   * @param projectId the given project identifier to set.
   * @return current {@link CreateObjectCommentRequest} instance.
   */
  public CreateObjectCommentRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the object type.
   */
  public ObjectType getObjectType() {
    return objectType;
  }

  /**
   * Sets the object type.
   *
   * @param objectType the given object type to set.
   */
  public void setObjectType(ObjectType objectType) {
    this.objectType = objectType;
  }

  /**
   * Sets the object type and return current instance.
   *
   * @param objectType the given object type to set.
   * @return current {@link CreateObjectCommentRequest} instance.
   */
  public CreateObjectCommentRequest withObjectType(ObjectType objectType) {
    setObjectType(objectType);
    return this;
  }

  /**
   * @return the object identifier that corresponding with the type.
   */
  public Long getObjectId() {
    return objectId;
  }

  /**
   * Sets object identifier from the given its value.
   *
   * @param objectId the given object identifier value to set.
   */
  public void setObjectId(Long objectId) {
    this.objectId = objectId;
  }

  /**
   * Sets object identifier from the given its value and return the current
   * instance.
   *
   * @param objectId the given object identifier value to set.
   * @return the current {@link CreateObjectCommentRequest} instance.
   */
  public CreateObjectCommentRequest withObjectId(Long objectId) {
    setObjectId(objectId);
    return this;
  }

  /**
   * @return the object's comment.
   */
  public String getComment() {
    return comment;
  }

  /**
   * Sets object comment.
   *
   * @param comment the given object comment value to set.
   */
  public void setComment(String comment) {
    this.comment = comment;
  }

  /**
   * Sets object comment and return current instance.
   *
   * @param comment the given object comment value to set.
   * @return the current {@link CreateObjectCommentRequest} instance.
   */
  public CreateObjectCommentRequest withComment(String comment) {
    setComment(comment);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateObjectCommentRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(", \n");
    sb.append("\tobjectId: ").append(objectId).append(", \n");
    sb.append("\tobjectType: ").append(objectType).append(", \n");
    sb.append("\tcomment: \n").append(comment).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
