package org.qas.qtest.api.internal.model;

/**
 * ArtifactLevel
 *
 * @author Dzung Nguyen
 * @version $Id ArtifactLevel 2015-05-28 15:26:30z dzungvnguyen $
 * @since 1.0
 */
public enum ArtifactLevel {
  //~ class properties ========================================================
  ROOT("root"),
  RELEASE("release"),
  TEST_CYCLE("test-cycle"),
  TEST_SUITE("test-suite");

  private final String queryParam;
  //~ class members ===========================================================
  /**
   * Creates artifact level with query parameter.
   *
   * @param queryParam the given artifact level query parameter.
   */
  ArtifactLevel(String queryParam) {
    this.queryParam = queryParam;
  }

  /**
   * @return artifact level query param.
   */
  public String getQueryParam() {
    return queryParam;
  }
}
