package org.qas.qtest.api.auth;

/**
 * QTestCredentialsProvider
 *
 * @author Dzung Nguyen
 * @version $Id QTestCredentialsProvider 2014-03-27 13:27:30z dungvnguyen $
 * @since 1.0
 */
public interface QTestCredentialsProvider {
  /**
   * Returns the {@link QTestCredentials credentials} which the caller can use to
   * authorize an qTest request. Each implementation of {@link QTestCredentialsProvider}
   * can chose its own strategy for loading credentials.
   *
   * @return {@link QTestCredentials} which the caller can use to authorize an qTest request.
   */
  QTestCredentials getCredentials();

  /**
   * Forces this credentials provider to refresh its credentials.
   */
  void refresh();
}
