package org.qas.qtest.api.auth;

import org.qas.api.AuthClientException;

/**
 * EnvironmentVariableQTestCredentialsProvider
 *
 * @author Dzung Nguyen
 * @version $Id EnvironmentVariableQTestCredentialsProvider 2014-03-27 13:32:30z dungvnguyen $
 * @since 1.0
 */
public class EnvironmentVariableQTestCredentialsProvider implements QTestCredentialsProvider {
  //~ class properties ========================================================
  private static final String TOKEN_ENV_VAR = "QTEST_AUTH_TOKEN";

  //~ class members ===========================================================
  public QTestCredentials getCredentials() {
    if (System.getenv(TOKEN_ENV_VAR) != null) {
      return new BasicQTestCredentials(System.getenv(TOKEN_ENV_VAR));
    }

    throw new AuthClientException("Unable to load qTest authentication token from the environment variables " +
        "(" + TOKEN_ENV_VAR + ")");
  }

  public void refresh() {}
}
