package org.qas.api.transform;

import org.qas.api.internal.util.google.io.CharStreams;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class StringUnmarshaller implements Unmarshaller<String, InputStream> {
  @Override
  public boolean isParseJson() {
    return false;
  }
  
  @Override
  public String unmarshall(InputStream in) throws Exception {
    List<String> lines = CharStreams.readLines(new InputStreamReader(in));
    return (lines == null || lines.isEmpty() ? null : lines.iterator().next());
  }
  
  @Override
  public String parse(String data) throws Exception {
    return null;
  }
}
