/*
 * Copyright (C) 2009 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.qas.api.internal.util.google.io;

import java.io.IOException;

/**
 * LineProcessor
 *
 * @author Dzung Nguyen
 * @version $Id LineProcessor 2014-03-26 19:57:30z dungvnguyen $
 * @since 1.0
 */
public interface LineProcessor<T> {
  /**
   * This method will be called once for each line.
   *
   * @param line the line read from the input, without delimiter
   * @return true to continue processing, false to stop
   */
  boolean processLine(String line) throws IOException;

  /** Return the result of processing all the lines. */
  T getResult();
}
