package org.qas.api.auth;

import org.qas.api.AuthClientException;
import org.qas.api.Credentials;
import org.qas.api.Request;

/**
 * Signer
 *
 * @author: Dzung Nguyen
 * @version: $Id Signer 2014-03-26 17:43:30z dungvnguyen $
 * @since 1.0
 */
public interface Signer {
  /**
   * Signs the request from the specified credentials.
   *
   * @param request the request to sign.
   * @param credentials the credentials used to sign the request.
   * @throws AuthClientException if an error occurs during signing the request.
   */
  void sign(Request request, Credentials credentials) throws AuthClientException;
}
