package org.qas.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.qas.api.internal.util.Dates;

import java.io.IOException;
import java.util.Date;

/**
 * @author trongle
 * @version $Id 5/5/2017 5:46 PM
 */
public class DateTimeSerializer extends JsonSerializer<Date> {
  @Override
  public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
    jgen.writeString(Dates.getInstance().formatAlternateIso8601Date(value));
  }
}
