package org.qas.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.qas.api.internal.util.Dates;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

/**
 * @author trongle
 * @version $Id 5/5/2017 5:46 PM
 */
public class DateTimeDeserializer extends JsonDeserializer<Date> {

  @Override
  public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
    try {
      return Dates.getInstance().parseIso8601Date(p.getText().trim());
    } catch (ParseException e) {
      return null;
    }
  }
}
