/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.get;

import android.database.Cursor;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.MapSomethingToExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlockingSingle;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.get.DefaultGetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.GetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.PreparedGet;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;
import rx.Single;
import rx.schedulers.Schedulers;

public class PreparedGetNumberOfResults
extends PreparedGet<Integer> {
    @NonNull
    private final GetResolver<Integer> getResolver;

    PreparedGetNumberOfResults(@NonNull StorIOSQLite storIOSQLite, @NonNull Query query, @NonNull GetResolver<Integer> getResolver) {
        super(storIOSQLite, query);
        this.getResolver = getResolver;
    }

    PreparedGetNumberOfResults(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery, @NonNull GetResolver<Integer> getResolver) {
        super(storIOSQLite, rawQuery);
        this.getResolver = getResolver;
    }

    @WorkerThread
    @NonNull
    public Integer executeAsBlocking() {
        Integer n;
        Cursor cursor;
        if (this.query != null) {
            cursor = this.getResolver.performGet(this.storIOSQLite, this.query);
        } else if (this.rawQuery != null) {
            cursor = this.getResolver.performGet(this.storIOSQLite, this.rawQuery);
        } else {
            throw new IllegalStateException("Please specify query");
        }
        try {
            n = this.getResolver.mapFromCursor(cursor);
        }
        catch (Throwable throwable) {
            try {
                cursor.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new StorIOException("Error has occurred during Get operation. query = " + (this.query != null ? this.query : this.rawQuery), (Throwable)exception);
            }
        }
        cursor.close();
        return n;
    }

    @NonNull
    public Observable<Integer> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<Integer> asRxObservable() {
        Set<Object> tables;
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        if (this.query != null) {
            tables = new HashSet<String>(1);
            tables.add(this.query.table());
        } else if (this.rawQuery != null) {
            tables = this.rawQuery.observesTables();
        } else {
            throw new StorIOException("Please specify query");
        }
        if (!tables.isEmpty()) {
            return this.storIOSQLite.observeChangesInTables(tables).map(MapSomethingToExecuteAsBlocking.newInstance((PreparedOperation)this)).startWith(Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this))).onBackpressureLatest().subscribeOn(Schedulers.io());
        }
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    @NonNull
    @CheckResult
    public Single<Integer> asRxSingle() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxSingle()");
        return Single.create((Single.OnSubscribe)OnSubscribeExecuteAsBlockingSingle.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static class CompleteBuilder {
        @NonNull
        static final GetResolver<Integer> STANDARD_GET_RESOLVER = new DefaultGetResolver<Integer>(){

            @Override
            @NonNull
            public Integer mapFromCursor(@NonNull Cursor cursor) {
                return cursor.getCount();
            }
        };
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @Nullable
        Query query;
        @Nullable
        RawQuery rawQuery;
        @Nullable
        private GetResolver<Integer> getResolver;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Query query) {
            this.storIOSQLite = storIOSQLite;
            this.query = query;
            this.rawQuery = null;
        }

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery) {
            this.storIOSQLite = storIOSQLite;
            this.rawQuery = rawQuery;
            this.query = null;
        }

        @NonNull
        public CompleteBuilder withGetResolver(@Nullable GetResolver<Integer> getResolver) {
            this.getResolver = getResolver;
            return this;
        }

        @NonNull
        public PreparedGetNumberOfResults prepare() {
            if (this.getResolver == null) {
                this.getResolver = STANDARD_GET_RESOLVER;
            }
            if (this.query != null) {
                return new PreparedGetNumberOfResults(this.storIOSQLite, this.query, this.getResolver);
            }
            if (this.rawQuery != null) {
                return new PreparedGetNumberOfResults(this.storIOSQLite, this.rawQuery, this.getResolver);
            }
            throw new IllegalStateException("Please specify query");
        }
    }

    public static class Builder {
        @NonNull
        private final StorIOSQLite storIOSQLite;

        Builder(@NonNull StorIOSQLite storIOSQLite) {
            this.storIOSQLite = storIOSQLite;
        }

        @NonNull
        public CompleteBuilder withQuery(@NonNull Query query) {
            Checks.checkNotNull((Object)query, (String)"Please specify query");
            return new CompleteBuilder(this.storIOSQLite, query);
        }

        @NonNull
        public CompleteBuilder withQuery(@NonNull RawQuery rawQuery) {
            Checks.checkNotNull((Object)rawQuery, (String)"Please specify rawQuery");
            return new CompleteBuilder(this.storIOSQLite, rawQuery);
        }
    }
}

