/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.content.ContentValues;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlockingSingle;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import rx.Observable;
import rx.Single;
import rx.schedulers.Schedulers;

public class PreparedPutContentValues
extends PreparedPut<PutResult> {
    @NonNull
    private final ContentValues contentValues;
    @NonNull
    private final PutResolver<ContentValues> putResolver;

    PreparedPutContentValues(@NonNull StorIOSQLite storIOSQLite, @NonNull ContentValues contentValues, @NonNull PutResolver<ContentValues> putResolver) {
        super(storIOSQLite);
        this.contentValues = contentValues;
        this.putResolver = putResolver;
    }

    @WorkerThread
    @NonNull
    public PutResult executeAsBlocking() {
        try {
            PutResult putResult = this.putResolver.performPut(this.storIOSQLite, this.contentValues);
            if (putResult.wasInserted() || putResult.wasUpdated()) {
                this.storIOSQLite.internal().notifyAboutChanges(Changes.newInstance(putResult.affectedTables()));
            }
            return putResult;
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Delete operation. contentValues = " + this.contentValues, (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<PutResult> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<PutResult> asRxObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    @NonNull
    @CheckResult
    public Single<PutResult> asRxSingle() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxSingle()");
        return Single.create((Single.OnSubscribe)OnSubscribeExecuteAsBlockingSingle.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static class CompleteBuilder {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final ContentValues contentValues;
        @NonNull
        private final PutResolver<ContentValues> putResolver;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull ContentValues contentValues, @NonNull PutResolver<ContentValues> putResolver) {
            this.storIOSQLite = storIOSQLite;
            this.contentValues = contentValues;
            this.putResolver = putResolver;
        }

        @NonNull
        public PreparedPutContentValues prepare() {
            return new PreparedPutContentValues(this.storIOSQLite, this.contentValues, this.putResolver);
        }
    }

    public static class Builder {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final ContentValues contentValues;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull ContentValues contentValues) {
            this.storIOSQLite = storIOSQLite;
            this.contentValues = contentValues;
        }

        @NonNull
        public CompleteBuilder withPutResolver(@NonNull PutResolver<ContentValues> putResolver) {
            Checks.checkNotNull(putResolver, (String)"Please specify put resolver");
            return new CompleteBuilder(this.storIOSQLite, this.contentValues, putResolver);
        }
    }
}

