/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlockingSingle;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import com.pushtorefresh.storio.sqlite.operations.put.PutResults;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import rx.Observable;
import rx.Single;
import rx.schedulers.Schedulers;

public class PreparedPutCollectionOfObjects<T>
extends PreparedPut<PutResults<T>> {
    @NonNull
    private final Collection<T> objects;
    private final boolean useTransaction;
    @Nullable
    private final PutResolver<T> explicitPutResolver;

    PreparedPutCollectionOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Collection<T> objects, @Nullable PutResolver<T> explicitPutResolver, boolean useTransaction) {
        super(storIOSQLite);
        this.objects = objects;
        this.useTransaction = useTransaction;
        this.explicitPutResolver = explicitPutResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NonNull
    public PutResults<T> executeAsBlocking() {
        try {
            ArrayList objectsAndPutResolvers;
            StorIOSQLite.Internal internal = this.storIOSQLite.internal();
            if (this.explicitPutResolver != null) {
                objectsAndPutResolvers = null;
            } else {
                objectsAndPutResolvers = new ArrayList(this.objects.size());
                for (T object : this.objects) {
                    SQLiteTypeMapping<?> typeMapping = internal.typeMapping(object.getClass());
                    if (typeMapping == null) {
                        throw new IllegalStateException("One of the objects from the collection does not have type mapping: object = " + object + ", object.class = " + object.getClass() + "," + "db was not affected by this operation, please add type mapping for this type");
                    }
                    objectsAndPutResolvers.add(new AbstractMap.SimpleImmutableEntry(object, typeMapping.putResolver()));
                }
            }
            if (this.useTransaction) {
                internal.beginTransaction();
            }
            HashMap<Object, PutResult> results = new HashMap<Object, PutResult>(this.objects.size());
            boolean transactionSuccessful = false;
            try {
                if (this.explicitPutResolver != null) {
                    for (T t : this.objects) {
                        PutResult putResult = this.explicitPutResolver.performPut(this.storIOSQLite, t);
                        results.put(t, putResult);
                        if (this.useTransaction || !putResult.wasInserted() && !putResult.wasUpdated()) continue;
                        internal.notifyAboutChanges(Changes.newInstance(putResult.affectedTables()));
                    }
                } else {
                    for (AbstractMap.SimpleImmutableEntry simpleImmutableEntry : objectsAndPutResolvers) {
                        Object object = simpleImmutableEntry.getKey();
                        PutResolver putResolver = (PutResolver)simpleImmutableEntry.getValue();
                        PutResult putResult = putResolver.performPut(this.storIOSQLite, object);
                        results.put(object, putResult);
                        if (this.useTransaction || !putResult.wasInserted() && !putResult.wasUpdated()) continue;
                        internal.notifyAboutChanges(Changes.newInstance(putResult.affectedTables()));
                    }
                }
                if (this.useTransaction) {
                    internal.setTransactionSuccessful();
                    transactionSuccessful = true;
                }
            }
            finally {
                if (this.useTransaction) {
                    internal.endTransaction();
                    if (transactionSuccessful) {
                        HashSet<String> affectedTables = new HashSet<String>(1);
                        for (Object object : results.keySet()) {
                            PutResult putResult = (PutResult)results.get(object);
                            if (!putResult.wasInserted() && !putResult.wasUpdated()) continue;
                            affectedTables.addAll(putResult.affectedTables());
                        }
                        if (!affectedTables.isEmpty()) {
                            internal.notifyAboutChanges(Changes.newInstance(affectedTables));
                        }
                    }
                }
            }
            return PutResults.newInstance(results);
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Delete operation. objects = " + this.objects, (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<PutResults<T>> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    public Observable<PutResults<T>> asRxObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    @NonNull
    @CheckResult
    public Single<PutResults<T>> asRxSingle() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxSingle()");
        return Single.create((Single.OnSubscribe)OnSubscribeExecuteAsBlockingSingle.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Collection<T> objects;
        private PutResolver<T> putResolver;
        private boolean useTransaction = true;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull Collection<T> objects) {
            this.storIOSQLite = storIOSQLite;
            this.objects = objects;
        }

        @NonNull
        public Builder<T> withPutResolver(@NonNull PutResolver<T> putResolver) {
            this.putResolver = putResolver;
            return this;
        }

        @NonNull
        public Builder<T> useTransaction(boolean useTransaction) {
            this.useTransaction = useTransaction;
            return this;
        }

        @NonNull
        public PreparedPutCollectionOfObjects<T> prepare() {
            return new PreparedPutCollectionOfObjects<T>(this.storIOSQLite, this.objects, this.putResolver, this.useTransaction);
        }
    }
}

