/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.get;

import android.database.Cursor;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.MapSomethingToExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.get.GetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.PreparedGet;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.schedulers.Schedulers;

public final class PreparedGetListOfObjects<T>
extends PreparedGet<List<T>> {
    @NonNull
    private final Class<T> type;
    @Nullable
    private final GetResolver<T> explicitGetResolver;

    PreparedGetListOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull Query query, @Nullable GetResolver<T> explicitGetResolver) {
        super(storIOSQLite, query);
        this.type = type;
        this.explicitGetResolver = explicitGetResolver;
    }

    PreparedGetListOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull RawQuery rawQuery, @Nullable GetResolver<T> explicitGetResolver) {
        super(storIOSQLite, rawQuery);
        this.type = type;
        this.explicitGetResolver = explicitGetResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @NonNull
    public List<T> executeAsBlocking() {
        try {
            Cursor cursor;
            GetResolver<T> getResolver;
            if (this.explicitGetResolver != null) {
                getResolver = this.explicitGetResolver;
            } else {
                SQLiteTypeMapping<T> typeMapping = this.storIOSQLite.internal().typeMapping(this.type);
                if (typeMapping == null) {
                    throw new IllegalStateException("This type does not have type mapping: type = " + this.type + "," + "db was not touched by this operation, please add type mapping for this type");
                }
                getResolver = typeMapping.getResolver();
            }
            if (this.query != null) {
                cursor = getResolver.performGet(this.storIOSQLite, this.query);
            } else {
                if (this.rawQuery == null) throw new IllegalStateException("Please specify query");
                cursor = getResolver.performGet(this.storIOSQLite, this.rawQuery);
            }
            try {
                int count = cursor.getCount();
                if (count == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                ArrayList<T> list = new ArrayList<T>(count);
                while (cursor.moveToNext()) {
                    list.add(getResolver.mapFromCursor(cursor));
                }
                List list2 = Collections.unmodifiableList(list);
                return list2;
            }
            finally {
                cursor.close();
            }
        }
        catch (Exception exception) {
            throw new StorIOException((Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<List<T>> createObservable() {
        Set<String> tables;
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"createObservable()");
        if (this.query != null) {
            tables = Collections.singleton(this.query.table());
        } else if (this.rawQuery != null) {
            tables = this.rawQuery.observesTables();
        } else {
            throw new IllegalStateException("Please specify query");
        }
        if (!tables.isEmpty()) {
            return this.storIOSQLite.observeChangesInTables(tables).map(MapSomethingToExecuteAsBlocking.newInstance((PreparedOperation)this)).startWith(Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this))).onBackpressureLatest().subscribeOn(Schedulers.io());
        }
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static final class CompleteBuilder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Class<T> type;
        @Nullable
        Query query;
        @Nullable
        RawQuery rawQuery;
        @Nullable
        private GetResolver<T> getResolver;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull Query query) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
            this.query = query;
            this.rawQuery = null;
        }

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull RawQuery rawQuery) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
            this.rawQuery = rawQuery;
            this.query = null;
        }

        @NonNull
        public CompleteBuilder<T> withGetResolver(@Nullable GetResolver<T> getResolver) {
            this.getResolver = getResolver;
            return this;
        }

        @NonNull
        public PreparedGetListOfObjects<T> prepare() {
            if (this.query != null) {
                return new PreparedGetListOfObjects<T>(this.storIOSQLite, this.type, this.query, this.getResolver);
            }
            if (this.rawQuery != null) {
                return new PreparedGetListOfObjects<T>(this.storIOSQLite, this.type, this.rawQuery, this.getResolver);
            }
            throw new IllegalStateException("Please specify Query or RawQuery");
        }
    }

    public static final class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Class<T> type;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
        }

        @NonNull
        public CompleteBuilder<T> withQuery(@NonNull Query query) {
            Checks.checkNotNull((Object)query, (String)"Please specify query");
            return new CompleteBuilder<T>(this.storIOSQLite, this.type, query);
        }

        @NonNull
        public CompleteBuilder<T> withQuery(@NonNull RawQuery rawQuery) {
            Checks.checkNotNull((Object)rawQuery, (String)"Please specify rawQuery");
            return new CompleteBuilder<T>(this.storIOSQLite, this.type, rawQuery);
        }
    }
}

