/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.delete;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResolver;
import com.pushtorefresh.storio.sqlite.operations.delete.DeleteResult;
import com.pushtorefresh.storio.sqlite.operations.delete.PreparedDelete;
import rx.Observable;
import rx.schedulers.Schedulers;

public final class PreparedDeleteObject<T>
extends PreparedDelete<DeleteResult> {
    @NonNull
    private final T object;
    @Nullable
    private final DeleteResolver<T> explicitDeleteResolver;

    PreparedDeleteObject(@NonNull StorIOSQLite storIOSQLite, @NonNull T object, @Nullable DeleteResolver<T> explicitDeleteResolver) {
        super(storIOSQLite);
        this.object = object;
        this.explicitDeleteResolver = explicitDeleteResolver;
    }

    @WorkerThread
    @NonNull
    public DeleteResult executeAsBlocking() {
        try {
            DeleteResolver<Object> deleteResolver;
            StorIOSQLite.Internal internal = this.storIOSQLite.internal();
            if (this.explicitDeleteResolver != null) {
                deleteResolver = this.explicitDeleteResolver;
            } else {
                SQLiteTypeMapping<?> typeMapping = internal.typeMapping(this.object.getClass());
                if (typeMapping == null) {
                    throw new IllegalStateException("Object does not have type mapping: object = " + this.object + ", object.class = " + this.object.getClass() + "," + "db was not affected by this operation, please add type mapping for this type");
                }
                deleteResolver = typeMapping.deleteResolver();
            }
            DeleteResult deleteResult = deleteResolver.performDelete(this.storIOSQLite, this.object);
            internal.notifyAboutChanges(Changes.newInstance(deleteResult.affectedTables()));
            return deleteResult;
        }
        catch (Exception exception) {
            throw new StorIOException((Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<DeleteResult> createObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"createObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static final class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final T object;
        private DeleteResolver<T> deleteResolver;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull T object) {
            this.storIOSQLite = storIOSQLite;
            this.object = object;
        }

        @NonNull
        public Builder<T> withDeleteResolver(@NonNull DeleteResolver<T> deleteResolver) {
            this.deleteResolver = deleteResolver;
            return this;
        }

        @NonNull
        public PreparedDeleteObject<T> prepare() {
            return new PreparedDeleteObject<T>(this.storIOSQLite, this.object, this.deleteResolver);
        }
    }
}

