/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.impl;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.internal.ChangesBus;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.internal.InternalQueries;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.impl.ChangesFilter;
import com.pushtorefresh.storio.sqlite.queries.DeleteQuery;
import com.pushtorefresh.storio.sqlite.queries.InsertQuery;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import com.pushtorefresh.storio.sqlite.queries.UpdateQuery;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;

public class DefaultStorIOSQLite
extends StorIOSQLite {
    @NonNull
    private final SQLiteOpenHelper sqLiteOpenHelper;
    @NonNull
    private final ChangesBus<Changes> changesBus = new ChangesBus(Environment.RX_JAVA_IS_IN_THE_CLASS_PATH);
    @NonNull
    private final StorIOSQLite.Internal internal;

    protected DefaultStorIOSQLite(@NonNull SQLiteOpenHelper sqLiteOpenHelper, @Nullable Map<Class<?>, SQLiteTypeMapping<?>> typesMapping) {
        this.sqLiteOpenHelper = sqLiteOpenHelper;
        this.internal = new InternalImpl(typesMapping);
    }

    @Override
    @NonNull
    public Observable<Changes> observeChangesInTables(@NonNull Set<String> tables) {
        Observable rxBus = this.changesBus.asObservable();
        if (rxBus == null) {
            throw new IllegalStateException("Observing changes in StorIOSQLite requires RxJava");
        }
        return ChangesFilter.apply((Observable<Changes>)rxBus, tables);
    }

    @Override
    @NonNull
    public StorIOSQLite.Internal internal() {
        return this.internal;
    }

    @Override
    public void close() throws IOException {
        this.sqLiteOpenHelper.close();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    protected class InternalImpl
    extends StorIOSQLite.Internal {
        @NonNull
        private final Object lock = new Object();
        @Nullable
        private final Map<Class<?>, SQLiteTypeMapping<?>> directTypesMapping;
        @NonNull
        private final Map<Class<?>, SQLiteTypeMapping<?>> indirectTypesMappingCache = new ConcurrentHashMap();
        @NonNull
        private AtomicInteger numberOfRunningTransactions = new AtomicInteger(0);
        @NonNull
        private Set<Changes> pendingChanges = new HashSet<Changes>(5);

        protected InternalImpl(Map<Class<?>, SQLiteTypeMapping<?>> typesMapping) {
            this.directTypesMapping = typesMapping != null ? Collections.unmodifiableMap(typesMapping) : null;
        }

        @Override
        @Nullable
        public <T> SQLiteTypeMapping<T> typeMapping(@NonNull Class<T> type) {
            if (this.directTypesMapping == null) {
                return null;
            }
            SQLiteTypeMapping<?> directTypeMapping = this.directTypesMapping.get(type);
            if (directTypeMapping != null) {
                return directTypeMapping;
            }
            SQLiteTypeMapping<?> indirectTypeMapping = this.indirectTypesMappingCache.get(type);
            if (indirectTypeMapping != null) {
                return indirectTypeMapping;
            }
            for (Class<T> parentType = type.getSuperclass(); parentType != Object.class; parentType = parentType.getSuperclass()) {
                indirectTypeMapping = this.directTypesMapping.get(parentType);
                if (indirectTypeMapping == null) continue;
                this.indirectTypesMappingCache.put(type, indirectTypeMapping);
                return indirectTypeMapping;
            }
            return null;
        }

        @Override
        @WorkerThread
        public void executeSQL(@NonNull RawQuery rawQuery) {
            if (rawQuery.args().isEmpty()) {
                DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().execSQL(rawQuery.query());
            } else {
                DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().execSQL(rawQuery.query(), (Object[])rawQuery.args().toArray(new String[rawQuery.args().size()]));
            }
        }

        @Override
        @WorkerThread
        @NonNull
        public Cursor rawQuery(@NonNull RawQuery rawQuery) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getReadableDatabase().rawQuery(rawQuery.query(), InternalQueries.nullableArrayOfStrings(rawQuery.args()));
        }

        @Override
        @WorkerThread
        @NonNull
        public Cursor query(@NonNull Query query) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getReadableDatabase().query(query.distinct(), query.table(), InternalQueries.nullableArrayOfStrings(query.columns()), InternalQueries.nullableString((String)query.where()), InternalQueries.nullableArrayOfStrings(query.whereArgs()), InternalQueries.nullableString((String)query.groupBy()), InternalQueries.nullableString((String)query.having()), InternalQueries.nullableString((String)query.orderBy()), InternalQueries.nullableString((String)query.limit()));
        }

        @Override
        @WorkerThread
        public long insert(@NonNull InsertQuery insertQuery, @NonNull ContentValues contentValues) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().insertOrThrow(insertQuery.table(), insertQuery.nullColumnHack(), contentValues);
        }

        @Override
        @WorkerThread
        public int update(@NonNull UpdateQuery updateQuery, @NonNull ContentValues contentValues) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().update(updateQuery.table(), contentValues, InternalQueries.nullableString((String)updateQuery.where()), InternalQueries.nullableArrayOfStrings(updateQuery.whereArgs()));
        }

        @Override
        @WorkerThread
        public int delete(@NonNull DeleteQuery deleteQuery) {
            return DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().delete(deleteQuery.table(), InternalQueries.nullableString((String)deleteQuery.where()), InternalQueries.nullableArrayOfStrings(deleteQuery.whereArgs()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAboutChanges(@NonNull Changes changes) {
            if (this.numberOfRunningTransactions.get() == 0) {
                DefaultStorIOSQLite.this.changesBus.onNext((Object)changes);
            } else {
                Object object = this.lock;
                synchronized (object) {
                    this.pendingChanges.add(changes);
                }
                this.notifyAboutPendingChangesIfNotInTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAboutPendingChangesIfNotInTransaction() {
            Set<Changes> changesToSend;
            if (this.numberOfRunningTransactions.get() == 0) {
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    changesToSend = this.pendingChanges;
                    this.pendingChanges = new HashSet<Changes>(5);
                }
            } else {
                changesToSend = null;
            }
            if (changesToSend != null) {
                for (Changes changes : changesToSend) {
                    DefaultStorIOSQLite.this.changesBus.onNext((Object)changes);
                }
            }
        }

        @Override
        public void beginTransaction() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().beginTransaction();
            this.numberOfRunningTransactions.incrementAndGet();
        }

        @Override
        public void setTransactionSuccessful() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().setTransactionSuccessful();
        }

        @Override
        public void endTransaction() {
            DefaultStorIOSQLite.this.sqLiteOpenHelper.getWritableDatabase().endTransaction();
            this.numberOfRunningTransactions.decrementAndGet();
            this.notifyAboutPendingChangesIfNotInTransaction();
        }
    }

    public static final class CompleteBuilder {
        @NonNull
        private final SQLiteOpenHelper sqLiteOpenHelper;
        private Map<Class<?>, SQLiteTypeMapping<?>> typesMapping;

        CompleteBuilder(@NonNull SQLiteOpenHelper sqLiteOpenHelper) {
            this.sqLiteOpenHelper = sqLiteOpenHelper;
        }

        @NonNull
        public <T> CompleteBuilder addTypeMapping(@NonNull Class<T> type, @NonNull SQLiteTypeMapping<T> typeMapping) {
            Checks.checkNotNull(type, (String)"Please specify type");
            Checks.checkNotNull(typeMapping, (String)"Please specify type mapping");
            if (this.typesMapping == null) {
                this.typesMapping = new HashMap();
            }
            this.typesMapping.put(type, typeMapping);
            return this;
        }

        @NonNull
        public DefaultStorIOSQLite build() {
            return new DefaultStorIOSQLite(this.sqLiteOpenHelper, this.typesMapping);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder sqliteOpenHelper(@NonNull SQLiteOpenHelper sqliteOpenHelper) {
            Checks.checkNotNull((Object)sqliteOpenHelper, (String)"Please specify SQLiteOpenHelper instance");
            return new CompleteBuilder(sqliteOpenHelper);
        }
    }
}

