/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.operations.delete.PreparedDelete;
import com.pushtorefresh.storio.sqlite.operations.execute.PreparedExecuteSQL;
import com.pushtorefresh.storio.sqlite.operations.get.PreparedGet;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.queries.DeleteQuery;
import com.pushtorefresh.storio.sqlite.queries.InsertQuery;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import com.pushtorefresh.storio.sqlite.queries.UpdateQuery;
import java.io.Closeable;
import java.util.Collections;
import java.util.Set;
import rx.Observable;
import rx.Scheduler;

public abstract class StorIOSQLite
implements Closeable {
    @NonNull
    public PreparedExecuteSQL.Builder executeSQL() {
        return new PreparedExecuteSQL.Builder(this);
    }

    @NonNull
    public PreparedGet.Builder get() {
        return new PreparedGet.Builder(this);
    }

    @NonNull
    public PreparedPut.Builder put() {
        return new PreparedPut.Builder(this);
    }

    @NonNull
    public PreparedDelete.Builder delete() {
        return new PreparedDelete.Builder(this);
    }

    @NonNull
    public abstract Observable<Changes> observeChanges();

    @NonNull
    public abstract Observable<Changes> observeChangesInTables(@NonNull Set<String> var1);

    @NonNull
    public Observable<Changes> observeChangesInTable(@NonNull String table) {
        Checks.checkNotEmpty((String)table, (String)"Table can not be null or empty");
        return this.observeChangesInTables(Collections.singleton(table));
    }

    @NonNull
    public abstract Observable<Changes> observeChangesOfTags(@NonNull Set<String> var1);

    @NonNull
    public Observable<Changes> observeChangesOfTag(@NonNull String tag) {
        Checks.checkNotEmpty((String)tag, (String)"Tag can not be null or empty");
        return this.observeChangesOfTags(Collections.singleton(tag));
    }

    @Nullable
    public abstract Scheduler defaultScheduler();

    @Deprecated
    @NonNull
    public abstract Internal internal();

    @NonNull
    public abstract LowLevel lowLevel();

    @Deprecated
    public static abstract class Internal
    extends LowLevel {
    }

    public static abstract class LowLevel {
        @Nullable
        public abstract <T> SQLiteTypeMapping<T> typeMapping(@NonNull Class<T> var1);

        @WorkerThread
        public abstract void executeSQL(@NonNull RawQuery var1);

        @WorkerThread
        @NonNull
        public abstract Cursor rawQuery(@NonNull RawQuery var1);

        @WorkerThread
        @NonNull
        public abstract Cursor query(@NonNull Query var1);

        @WorkerThread
        public abstract long insert(@NonNull InsertQuery var1, @NonNull ContentValues var2);

        @WorkerThread
        public abstract long insertWithOnConflict(@NonNull InsertQuery var1, @NonNull ContentValues var2, int var3);

        @WorkerThread
        public abstract int update(@NonNull UpdateQuery var1, @NonNull ContentValues var2);

        @WorkerThread
        public abstract int delete(@NonNull DeleteQuery var1);

        public abstract void notifyAboutChanges(@NonNull Changes var1);

        public abstract void beginTransaction();

        public abstract void setTransactionSuccessful();

        public abstract void endTransaction();

        @NonNull
        public abstract SQLiteOpenHelper sqliteOpenHelper();
    }
}

