/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.ChannelAuthorizer;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PresenceChannel;
import com.pusher.client.channel.PresenceChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.User;
import com.pusher.client.channel.impl.PrivateChannelImpl;
import com.pusher.client.channel.impl.message.ChannelData;
import com.pusher.client.channel.impl.message.PresenceMemberData;
import com.pusher.client.channel.impl.message.PresenceSubscriptionData;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PresenceChannelImpl
extends PrivateChannelImpl
implements PresenceChannel {
    private static final String MEMBER_ADDED_EVENT = "pusher_internal:member_added";
    private static final String MEMBER_REMOVED_EVENT = "pusher_internal:member_removed";
    private static final Gson GSON = new Gson();
    private final Map<String, User> idToUserMap = Collections.synchronizedMap(new LinkedHashMap());
    private String myUserID;

    public PresenceChannelImpl(InternalConnection connection, String channelName, ChannelAuthorizer channelAuthorizer, Factory factory) {
        super(connection, channelName, channelAuthorizer, factory);
    }

    @Override
    public Set<User> getUsers() {
        return new LinkedHashSet<User>(this.idToUserMap.values());
    }

    @Override
    public User getMe() {
        return this.idToUserMap.get(this.myUserID);
    }

    @Override
    public void handleEvent(PusherEvent event) {
        super.handleEvent(event);
        switch (event.getEventName()) {
            case "pusher_internal:subscription_succeeded": {
                this.handleSubscriptionSuccessfulMessage(event);
                break;
            }
            case "pusher_internal:member_added": {
                this.handleMemberAddedEvent(event);
                break;
            }
            case "pusher_internal:member_removed": {
                this.handleMemberRemovedEvent(event);
            }
        }
    }

    @Override
    public String toSubscribeMessage() {
        String msg = super.toSubscribeMessage();
        this.myUserID = this.extractUserIdFromChannelData(this.channelData);
        return msg;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PresenceChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PresenceChannelEventListener can be bound to a presence channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!presence-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Presence Channel: name=%s]", this.name);
    }

    private void handleSubscriptionSuccessfulMessage(PusherEvent event) {
        ChannelEventListener listener = this.getEventListener();
        PresenceSubscriptionData presenceSubscriptionData = (PresenceSubscriptionData)GSON.fromJson(event.getData(), PresenceSubscriptionData.class);
        if (presenceSubscriptionData.presence == null) {
            if (listener != null) {
                listener.onError("Subscription failed: Presence data not found", null);
            }
            return;
        }
        List<String> ids = presenceSubscriptionData.getIds();
        Map<String, Object> hash = presenceSubscriptionData.getHash();
        if (ids != null && !ids.isEmpty()) {
            for (String id : ids) {
                String userData = hash.get(id) != null ? GSON.toJson(hash.get(id)) : null;
                User user = new User(id, userData);
                this.idToUserMap.put(id, user);
            }
        }
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.onUsersInformationReceived(this.getName(), this.getUsers());
        }
    }

    private void handleMemberAddedEvent(PusherEvent event) {
        PresenceMemberData memberData = (PresenceMemberData)GSON.fromJson(event.getData(), PresenceMemberData.class);
        String id = memberData.getId();
        String userData = memberData.getInfo() != null ? GSON.toJson(memberData.getInfo()) : null;
        User user = new User(id, userData);
        this.idToUserMap.put(id, user);
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userSubscribed(this.getName(), user);
        }
    }

    private void handleMemberRemovedEvent(PusherEvent event) {
        PresenceMemberData memberData = (PresenceMemberData)GSON.fromJson(event.getData(), PresenceMemberData.class);
        User user = this.idToUserMap.remove(memberData.getId());
        ChannelEventListener listener = this.getEventListener();
        if (listener != null) {
            PresenceChannelEventListener presenceListener = (PresenceChannelEventListener)listener;
            presenceListener.userUnsubscribed(this.getName(), user);
        }
    }

    public String extractUserIdFromChannelData(String channelDataString) {
        try {
            ChannelData data = (ChannelData)GSON.fromJson(channelDataString, ChannelData.class);
            if (data.getUserId() == null) {
                throw new AuthorizationFailureException("Invalid response from ChannelAuthorizer: no user_id key in channel_data object: " + channelDataString);
            }
            return data.getUserId();
        }
        catch (JsonSyntaxException e) {
            throw new AuthorizationFailureException("Invalid response from ChannelAuthorizer: unable to parse channel_data object: " + channelDataString, (Exception)((Object)e));
        }
        catch (NullPointerException e) {
            throw new AuthorizationFailureException("Invalid response from ChannelAuthorizer: no user_id key in channel_data object: " + channelDataString);
        }
    }
}

