/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.JsonSyntaxException;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.ChannelAuthorizer;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateEncryptedChannel;
import com.pusher.client.channel.PrivateEncryptedChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.message.AuthResponse;
import com.pusher.client.channel.impl.message.EncryptedReceivedData;
import com.pusher.client.channel.impl.message.SubscribeMessage;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.crypto.nacl.AuthenticityException;
import com.pusher.client.crypto.nacl.SecretBoxOpener;
import com.pusher.client.crypto.nacl.SecretBoxOpenerFactory;
import com.pusher.client.util.Factory;
import com.pusher.client.util.internal.Base64;
import java.util.Map;
import java.util.Set;

public class PrivateEncryptedChannelImpl
extends ChannelImpl
implements PrivateEncryptedChannel {
    private final InternalConnection connection;
    private final ChannelAuthorizer channelAuthorizer;
    private SecretBoxOpenerFactory secretBoxOpenerFactory;
    private SecretBoxOpener secretBoxOpener;
    private ConnectionEventListener disposeSecretBoxOpenerOnDisconnectedListener = new ConnectionEventListener(){

        @Override
        public void onConnectionStateChange(ConnectionStateChange change) {
            PrivateEncryptedChannelImpl.this.disposeSecretBoxOpener();
        }

        @Override
        public void onError(String message, String code, Exception e) {
        }
    };

    public PrivateEncryptedChannelImpl(InternalConnection connection, String channelName, ChannelAuthorizer channelAuthorizer, Factory factory, SecretBoxOpenerFactory secretBoxOpenerFactory) {
        super(channelName, factory);
        this.connection = connection;
        this.channelAuthorizer = channelAuthorizer;
        this.secretBoxOpenerFactory = secretBoxOpenerFactory;
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PrivateEncryptedChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PrivateEncryptedChannelEventListener can be bound to a private encrypted channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    public String toSubscribeMessage() {
        return this.GSON.toJson((Object)new SubscribeMessage(this.name, this.authenticate(), null));
    }

    private String authenticate() {
        try {
            AuthResponse authResponse = (AuthResponse)this.GSON.fromJson(this.getAuthorizationResponse(), AuthResponse.class);
            if (authResponse.getAuth() == null || authResponse.getSharedSecret() == null) {
                throw new AuthorizationFailureException("Didn't receive all the fields expected from the ChannelAuthorizer, expected an auth and shared_secret.");
            }
            this.createSecretBoxOpener(Base64.decode(authResponse.getSharedSecret()));
            return authResponse.getAuth();
        }
        catch (JsonSyntaxException e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer");
        }
    }

    private void createSecretBoxOpener(byte[] key) {
        this.secretBoxOpener = this.secretBoxOpenerFactory.create(key);
        this.setListenerToDisposeSecretBoxOpenerOnDisconnected();
    }

    private void setListenerToDisposeSecretBoxOpenerOnDisconnected() {
        this.connection.bind(ConnectionState.DISCONNECTED, this.disposeSecretBoxOpenerOnDisconnectedListener);
    }

    @Override
    public void updateState(ChannelState state) {
        super.updateState(state);
        if (state == ChannelState.UNSUBSCRIBED) {
            this.disposeSecretBoxOpener();
        }
    }

    @Override
    public PusherEvent prepareEvent(String event, String message) {
        try {
            return this.decryptMessage(message);
        }
        catch (AuthenticityException e1) {
            this.disposeSecretBoxOpener();
            this.authenticate();
            try {
                return this.decryptMessage(message);
            }
            catch (AuthenticityException e2) {
                this.notifyListenersOfDecryptFailure(event, "Failed to decrypt message.");
                return null;
            }
        }
    }

    private void notifyListenersOfDecryptFailure(String event, String reason) {
        Set<SubscriptionEventListener> listeners = this.getInterestedListeners(event);
        if (listeners != null) {
            for (SubscriptionEventListener listener : listeners) {
                ((PrivateEncryptedChannelEventListener)listener).onDecryptionFailure(event, reason);
            }
        }
    }

    private PusherEvent decryptMessage(String message) {
        Map receivedMessage = (Map)this.GSON.fromJson(message, Map.class);
        EncryptedReceivedData encryptedReceivedData = (EncryptedReceivedData)this.GSON.fromJson((String)receivedMessage.get("data"), EncryptedReceivedData.class);
        String decryptedData = this.secretBoxOpener.open(encryptedReceivedData.getCiphertext(), encryptedReceivedData.getNonce());
        receivedMessage.put("data", decryptedData);
        return new PusherEvent(receivedMessage);
    }

    private void disposeSecretBoxOpener() {
        if (this.secretBoxOpener != null) {
            this.secretBoxOpener.clearKey();
            this.secretBoxOpener = null;
            this.removeListenerToDisposeSecretBoxOpenerOnDisconnected();
        }
    }

    private void removeListenerToDisposeSecretBoxOpenerOnDisconnected() {
        this.connection.unbind(ConnectionState.DISCONNECTED, this.disposeSecretBoxOpenerOnDisconnectedListener);
    }

    private String getAuthorizationResponse() {
        String socketId = this.connection.getSocketId();
        return this.channelAuthorizer.authorize(this.getName(), socketId);
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!private-encrypted-).*"};
    }

    @Override
    public String toString() {
        return String.format("[Private Encrypted Channel: name=%s]", this.name);
    }
}

