/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.ChannelAuthorizer;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.channel.impl.message.AuthResponse;
import com.pusher.client.channel.impl.message.SubscribeMessage;
import com.pusher.client.channel.impl.message.TriggerMessage;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;

public class PrivateChannelImpl
extends ChannelImpl
implements PrivateChannel {
    private static final Gson GSON = new Gson();
    private static final String CLIENT_EVENT_PREFIX = "client-";
    private final InternalConnection connection;
    private final ChannelAuthorizer channelAuthorizer;
    protected String channelData;

    public PrivateChannelImpl(InternalConnection connection, String channelName, ChannelAuthorizer channelAuthorizer, Factory factory) {
        super(channelName, factory);
        this.connection = connection;
        this.channelAuthorizer = channelAuthorizer;
    }

    @Override
    public void trigger(String eventName, String data) {
        if (eventName == null || !eventName.startsWith(CLIENT_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot trigger event " + eventName + ": client events must start with \"client-\"");
        }
        if (this.state != ChannelState.SUBSCRIBED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because channel " + this.name + " is in " + this.state.toString() + " state");
        }
        if (this.connection.getState() != ConnectionState.CONNECTED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because connection is in " + this.connection.getState().toString() + " state");
        }
        this.connection.sendMessage(GSON.toJson((Object)new TriggerMessage(eventName, this.name, data)));
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PrivateChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PrivateChannelEventListener can be bound to a private channel");
        }
        super.bind(eventName, listener);
    }

    private String authorize() {
        try {
            AuthResponse authResponse = (AuthResponse)GSON.fromJson(this.getAuthorizationResponse(), AuthResponse.class);
            this.channelData = authResponse.getChannelData();
            if (authResponse.getAuth() == null) {
                throw new AuthorizationFailureException("Didn't receive all the fields expected from the ChannelAuthorizer, expected an auth and shared_secret.");
            }
            return authResponse.getAuth();
        }
        catch (JsonSyntaxException e) {
            throw new AuthorizationFailureException("Unable to parse response from ChannelAuthorizer");
        }
    }

    @Override
    public String toSubscribeMessage() {
        return GSON.toJson((Object)new SubscribeMessage(this.name, this.authorize(), this.channelData));
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!private-).*", "^private-encrypted-.*"};
    }

    private String getAuthorizationResponse() {
        String socketId = this.connection.getSocketId();
        return this.channelAuthorizer.authorize(this.getName(), socketId);
    }

    @Override
    public String toString() {
        return String.format("[Private Channel: name=%s]", this.name);
    }
}

