/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pusher.client.AuthorizationFailureException;
import com.pusher.client.Authorizer;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.PrivateChannel;
import com.pusher.client.channel.PrivateChannelEventListener;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.ChannelImpl;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.impl.InternalConnection;
import com.pusher.client.util.Factory;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrivateChannelImpl
extends ChannelImpl
implements PrivateChannel {
    private static final Gson GSON = new Gson();
    private static final String CLIENT_EVENT_PREFIX = "client-";
    private final InternalConnection connection;
    private final Authorizer authorizer;

    public PrivateChannelImpl(InternalConnection connection, String channelName, Authorizer authorizer, Factory factory) {
        super(channelName, factory);
        this.connection = connection;
        this.authorizer = authorizer;
    }

    @Override
    public void trigger(String eventName, String data) {
        if (eventName == null || !eventName.startsWith(CLIENT_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot trigger event " + eventName + ": client events must start with \"client-\"");
        }
        if (this.state != ChannelState.SUBSCRIBED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because channel " + this.name + " is in " + this.state.toString() + " state");
        }
        if (this.connection.getState() != ConnectionState.CONNECTED) {
            throw new IllegalStateException("Cannot trigger event " + eventName + " because connection is in " + this.connection.getState().toString() + " state");
        }
        try {
            Map userData = (Map)GSON.fromJson(data, Map.class);
            LinkedHashMap<String, Object> jsonPayload = new LinkedHashMap<String, Object>();
            jsonPayload.put("event", eventName);
            jsonPayload.put("channel", this.name);
            jsonPayload.put("data", userData);
            String jsonMessage = GSON.toJson(jsonPayload);
            this.connection.sendMessage(jsonMessage);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("Cannot trigger event " + eventName + " because \"" + data + "\" could not be parsed as valid JSON");
        }
    }

    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        if (!(listener instanceof PrivateChannelEventListener)) {
            throw new IllegalArgumentException("Only instances of PrivateChannelEventListener can be bound to a private channel");
        }
        super.bind(eventName, listener);
    }

    @Override
    public String toSubscribeMessage() {
        String authResponse = this.getAuthResponse();
        try {
            Map authResponseMap = (Map)GSON.fromJson(authResponse, Map.class);
            String authKey = (String)authResponseMap.get("auth");
            LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
            jsonObject.put("event", "pusher:subscribe");
            LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
            dataMap.put("channel", this.name);
            dataMap.put("auth", authKey);
            jsonObject.put("data", dataMap);
            String json = GSON.toJson(jsonObject);
            return json;
        }
        catch (Exception e) {
            throw new AuthorizationFailureException("Unable to parse response from Authorizer: " + authResponse, e);
        }
    }

    @Override
    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^(?!private-).*"};
    }

    protected String getAuthResponse() {
        String socketId = this.connection.getSocketId();
        return this.authorizer.authorize(this.getName(), socketId);
    }

    @Override
    public String toString() {
        return String.format("[Private Channel: name=%s]", this.name);
    }
}

