/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.google.gson.Gson;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import com.pusher.client.util.Factory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ChannelImpl
implements InternalChannel {
    private static final String INTERNAL_EVENT_PREFIX = "pusher_internal:";
    protected static final String SUBSCRIPTION_SUCCESS_EVENT = "pusher_internal:subscription_succeeded";
    protected final String name;
    private final Map<String, Set<SubscriptionEventListener>> eventNameToListenerMap = new HashMap<String, Set<SubscriptionEventListener>>();
    protected volatile ChannelState state = ChannelState.INITIAL;
    private ChannelEventListener eventListener;
    private final Factory factory;
    private final Object lock = new Object();

    public ChannelImpl(String channelName, Factory factory) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot subscribe to a channel with a null name");
        }
        for (String disallowedPattern : this.getDisallowedNameExpressions()) {
            if (!channelName.matches(disallowedPattern)) continue;
            throw new IllegalArgumentException("Channel name " + channelName + " is invalid. Private channel names must start with \"private-\" and presence channel names must start with \"presence-\"");
        }
        this.name = channelName;
        this.factory = factory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners == null) {
                listeners = new HashSet<SubscriptionEventListener>();
                this.eventNameToListenerMap.put(eventName, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.eventNameToListenerMap.remove(eventName);
                }
            }
        }
    }

    @Override
    public boolean isSubscribed() {
        return this.state == ChannelState.SUBSCRIBED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(final String event, String message) {
        if (event.equals(SUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.SUBSCRIBED);
        } else {
            HashSet<SubscriptionEventListener> listeners;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                Set<SubscriptionEventListener> sharedListeners = this.eventNameToListenerMap.get(event);
                listeners = sharedListeners != null ? new HashSet<SubscriptionEventListener>(sharedListeners) : null;
            }
            if (listeners != null) {
                for (final SubscriptionEventListener listener : listeners) {
                    final String data = this.extractDataFrom(message);
                    this.factory.queueOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onEvent(ChannelImpl.this.name, event, data);
                        }
                    });
                }
            }
        }
    }

    @Override
    public String toSubscribeMessage() {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("event", "pusher:subscribe");
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("channel", this.name);
        jsonObject.put("data", dataMap);
        return new Gson().toJson(jsonObject);
    }

    @Override
    public String toUnsubscribeMessage() {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        jsonObject.put("event", "pusher:unsubscribe");
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("channel", this.name);
        jsonObject.put("data", dataMap);
        return new Gson().toJson(jsonObject);
    }

    @Override
    public void updateState(ChannelState state) {
        this.state = state;
        if (state == ChannelState.SUBSCRIBED && this.eventListener != null) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ChannelImpl.this.eventListener.onSubscriptionSucceeded(ChannelImpl.this.getName());
                }
            });
        }
    }

    @Override
    public void setEventListener(ChannelEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public ChannelEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public int compareTo(InternalChannel other) {
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.format("[Public Channel: name=%s]", this.name);
    }

    private String extractDataFrom(String message) {
        Gson gson = new Gson();
        Map jsonObject = (Map)gson.fromJson(message, Map.class);
        return (String)jsonObject.get("data");
    }

    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^private-.*", "^presence-.*"};
    }

    private void validateArguments(String eventName, SubscriptionEventListener listener) {
        if (eventName == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null event name");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null listener");
        }
        if (eventName.startsWith(INTERNAL_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot bind or unbind channel " + this.name + " with an internal event name such as " + eventName);
        }
        if (this.state == ChannelState.UNSUBSCRIBED) {
            throw new IllegalStateException("Cannot bind or unbind to events on a channel that has been unsubscribed. Call Pusher.subscribe() to resubscribe to this channel");
        }
    }
}

