/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DesignForExtensionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "design.forExtension";
    private Set<String> ignoredAnnotations = Stream.of("Test", "Before", "After", "BeforeClass", "AfterClass").collect(Collectors.toSet());

    public void setIgnoredAnnotations(String ... ignoredAnnotations) {
        this.ignoredAnnotations = Arrays.stream(ignoredAnnotations).collect(Collectors.toSet());
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST classDef;
        if (!this.hasJavadocComment(ast) && (this.isNativeMethod(ast) || !DesignForExtensionCheck.hasEmptyImplementation(ast)) && this.canBeOverridden(ast) && !DesignForExtensionCheck.hasIgnoredAnnotation(ast, this.ignoredAnnotations) && DesignForExtensionCheck.canBeSubclassed(classDef = DesignForExtensionCheck.getNearestClassOrEnumDefinition(ast))) {
            String className = classDef.findFirstToken(58).getText();
            String methodName = ast.findFirstToken(58).getText();
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, className, methodName);
        }
    }

    private boolean hasJavadocComment(DetailAST methodDef) {
        DetailAST modifiers = methodDef.findFirstToken(5);
        return modifiers.branchContains(145);
    }

    private boolean isNativeMethod(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        return mods.branchContains(66);
    }

    private static boolean hasEmptyImplementation(DetailAST ast) {
        DetailAST methodImplCloseBrace;
        Predicate<DetailAST> predicate;
        Optional<DetailAST> methodBody;
        boolean hasEmptyBody = true;
        DetailAST methodImplOpenBrace = ast.findFirstToken(7);
        if (methodImplOpenBrace != null && (methodBody = TokenUtils.findFirstTokenByPredicate(methodImplOpenBrace, predicate = arg_0 -> DesignForExtensionCheck.lambda$hasEmptyImplementation$0(methodImplCloseBrace = methodImplOpenBrace.getLastChild(), arg_0))).isPresent()) {
            hasEmptyBody = false;
        }
        return hasEmptyBody;
    }

    private boolean canBeOverridden(DetailAST methodDef) {
        DetailAST modifiers = methodDef.findFirstToken(5);
        return ScopeUtils.getSurroundingScope(methodDef).isIn(Scope.PROTECTED) && !ScopeUtils.isInInterfaceOrAnnotationBlock(methodDef) && !modifiers.branchContains(61) && !modifiers.branchContains(40) && !modifiers.branchContains(39) && !modifiers.branchContains(64);
    }

    private static boolean hasIgnoredAnnotation(DetailAST methodDef, Set<String> annotations) {
        return annotations.stream().filter(annotation -> DesignForExtensionCheck.hasAnnotation(methodDef, annotation)).findAny().isPresent();
    }

    private static boolean hasAnnotation(DetailAST methodDef, String annotationName) {
        Optional<DetailAST> annotation;
        DetailAST modifiers = methodDef.findFirstToken(5);
        boolean containsAnnotation = false;
        if (modifiers.branchContains(159) && (annotation = TokenUtils.findFirstTokenByPredicate(modifiers, currentToken -> currentToken != null && currentToken.getType() == 159 && annotationName.equals(DesignForExtensionCheck.getAnnotationName(currentToken)))).isPresent()) {
            containsAnnotation = true;
        }
        return containsAnnotation;
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST dotAst = annotation.findFirstToken(59);
        String name = dotAst == null ? annotation.findFirstToken(58).getText() : dotAst.findFirstToken(58).getText();
        return name;
    }

    private static DetailAST getNearestClassOrEnumDefinition(DetailAST ast) {
        DetailAST searchAST = ast;
        while (searchAST.getType() != 14 && searchAST.getType() != 154) {
            searchAST = searchAST.getParent();
        }
        return searchAST;
    }

    private static boolean canBeSubclassed(DetailAST classDef) {
        DetailAST modifiers = classDef.findFirstToken(5);
        return classDef.getType() != 154 && !modifiers.branchContains(39) && DesignForExtensionCheck.hasDefaultOrExplicitNonPrivateCtor(classDef);
    }

    private static boolean hasDefaultOrExplicitNonPrivateCtor(DetailAST classDef) {
        DetailAST objBlock = classDef.findFirstToken(6);
        boolean hasDefaultConstructor = true;
        boolean hasExplicitNonPrivateCtor = false;
        for (DetailAST candidate = objBlock.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (candidate.getType() != 8) continue;
            hasDefaultConstructor = false;
            DetailAST ctorMods = candidate.findFirstToken(5);
            if (ctorMods.branchContains(61)) continue;
            hasExplicitNonPrivateCtor = true;
            break;
        }
        return hasDefaultConstructor || hasExplicitNonPrivateCtor;
    }

    private static /* synthetic */ boolean lambda$hasEmptyImplementation$0(DetailAST methodImplCloseBrace, DetailAST currentNode) {
        return currentNode != null && currentNode != methodImplCloseBrace && currentNode.getLineNo() <= methodImplCloseBrace.getLineNo() && !TokenUtils.isCommentType(currentNode.getType());
    }
}

