/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.prove.proveapi.utils.BigDecimalString;
import com.prove.proveapi.utils.BigIntegerString;
import com.prove.proveapi.utils.EventStreamMessage;
import com.prove.proveapi.utils.HTTPRequest;
import com.prove.proveapi.utils.HeaderMetadata;
import com.prove.proveapi.utils.JSON;
import com.prove.proveapi.utils.PathParamsMetadata;
import com.prove.proveapi.utils.QueryParameter;
import com.prove.proveapi.utils.QueryParameters;
import com.prove.proveapi.utils.RequestBody;
import com.prove.proveapi.utils.Security;
import com.prove.proveapi.utils.SerializedBody;
import com.prove.proveapi.utils.Types;
import com.prove.proveapi.utils.Utf8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.openapitools.jackson.nullable.JsonNullable;

public final class Utils {
    private static final String DOLLAR_MARKER = "D9qPtyhOYzkHGu3c";
    private static final Map<Class<?>, java.util.function.Function<Object, Object>> STRING_CONVERSIONS = Map.of(BigInteger.class, o -> new BigIntegerString((BigInteger)o), BigDecimal.class, o -> new BigDecimalString((BigDecimal)o));
    private static final Map<Class<?>, java.util.function.Function<Object, Object>> STRING_INVERSE_CONVERSIONS = Map.of(BigIntegerString.class, o -> ((BigIntegerString)o).value(), BigDecimalString.class, o -> ((BigDecimalString)o).value());
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    private Utils() {
    }

    public static boolean referenceEquals(Object a, Object b) {
        return a == b;
    }

    public static String generateURL(String baseURL, String path) throws IllegalArgumentException, IllegalAccessException {
        if (baseURL != null && baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + path;
    }

    public static <T> String generateURL(Class<T> type, String baseURL, String path, JsonNullable<? extends T> params, Map<String, Map<String, Map<String, Object>>> globals) throws JsonProcessingException, IllegalArgumentException, IllegalAccessException {
        if (params.isPresent() && params.get() != null) {
            return Utils.generateURL(type, baseURL, path, params.get(), globals);
        }
        return baseURL;
    }

    public static <T> String generateURL(Class<T> type, String baseURL, String path, Optional<? extends T> params, Map<String, Map<String, Map<String, Object>>> globals) throws JsonProcessingException, IllegalArgumentException, IllegalAccessException {
        if (params.isPresent()) {
            return Utils.generateURL(type, baseURL, path, params.get(), globals);
        }
        return baseURL;
    }

    public static <T> String generateURL(Class<T> type, String baseURL, String path, T params, Map<String, Map<String, Map<String, Object>>> globals) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        Field[] fields;
        if (baseURL != null && baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        block11: for (Field field : fields = type.getDeclaredFields()) {
            field.setAccessible(true);
            PathParamsMetadata pathParamsMetadata = PathParamsMetadata.parse(field);
            if (pathParamsMetadata == null) continue;
            Object value = params != null ? field.get(params) : null;
            value = Utils.resolveOptionals(value);
            if ((value = Utils.populateGlobal(value, field.getName(), "pathParam", globals)) == null) continue;
            if (pathParamsMetadata.serialization != null && !pathParamsMetadata.serialization.isBlank()) {
                Map<String, String> serialized = Utils.parseSerializedParams(pathParamsMetadata, value);
                pathParams.putAll(serialized);
                continue;
            }
            switch (pathParamsMetadata.style) {
                case "simple": {
                    switch (Types.getType(value.getClass())) {
                        case ARRAY: {
                            List<?> array = Utils.toList(value);
                            if (array.isEmpty()) continue block11;
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", array.stream().map(v -> Utils.valToString(v)).map(v -> Utils.pathEncode(v, pathParamsMetadata.allowReserved)).collect(Collectors.toList())));
                            continue block11;
                        }
                        case MAP: {
                            Map map = (Map)value;
                            if (map.size() == 0) continue block11;
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", map.entrySet().stream().map(e -> {
                                if (pathParamsMetadata.explode) {
                                    return String.format("%s=%s", Utils.pathEncode(Utils.valToString(e.getKey()), false), Utils.pathEncode(Utils.valToString(e.getValue()), false));
                                }
                                return String.format("%s,%s", Utils.pathEncode(Utils.valToString(e.getKey()), false), Utils.pathEncode(Utils.valToString(e.getValue()), false));
                            }).collect(Collectors.toList())));
                            continue block11;
                        }
                        case OBJECT: {
                            Field[] valueFields;
                            if (!Utils.allowIntrospection(value.getClass())) {
                                pathParams.put(pathParamsMetadata.name, Utils.pathEncode(Utils.valToString(value), pathParamsMetadata.allowReserved));
                                continue block11;
                            }
                            ArrayList<String> values = new ArrayList<String>();
                            for (Field valueField : valueFields = value.getClass().getDeclaredFields()) {
                                valueField.setAccessible(true);
                                PathParamsMetadata valuePathParamsMetadata = PathParamsMetadata.parse(valueField);
                                if (valuePathParamsMetadata == null) continue;
                                Object val = valueField.get(value);
                                if ((val = Utils.resolveOptionals(val)) == null) continue;
                                if (pathParamsMetadata.explode) {
                                    values.add(String.format("%s=%s", valuePathParamsMetadata.name, Utils.pathEncode(Utils.valToString(val), valuePathParamsMetadata.allowReserved)));
                                    continue;
                                }
                                values.add(String.format("%s,%s", valuePathParamsMetadata.name, Utils.pathEncode(Utils.valToString(val), valuePathParamsMetadata.allowReserved)));
                            }
                            pathParams.put(pathParamsMetadata.name, String.join((CharSequence)",", values));
                            continue block11;
                        }
                        default: {
                            pathParams.put(pathParamsMetadata.name, Utils.pathEncode(Utils.valToString(value), pathParamsMetadata.allowReserved));
                        }
                    }
                }
            }
        }
        return baseURL + Utils.templateUrl(path, pathParams);
    }

    private static String pathEncode(String s, boolean allowReserved) {
        return Utf8UrlEncoder.allowReserved(allowReserved).encode(s);
    }

    public static boolean contentTypeMatches(String contentType, String pattern) {
        if (contentType == null || contentType.isBlank()) {
            return false;
        }
        if (contentType.equals(pattern) || pattern.equals("*") || pattern.equals("*/*")) {
            return true;
        }
        String[] contentTypeParts = contentType.split(";");
        if (contentTypeParts.length == 0) {
            return false;
        }
        String mediaType = contentTypeParts[0];
        if (mediaType.equals(pattern)) {
            return true;
        }
        String[] mediaTypeParts = mediaType.split("/");
        return mediaTypeParts.length == 2 && (String.format("%s/*", mediaTypeParts[0]).equals(pattern) || String.format("*/%s", mediaTypeParts[1]).equals(pattern));
    }

    public static boolean allowIntrospection(Class<?> cls) {
        return !cls.equals(BigInteger.class) && !cls.equals(BigDecimal.class) && !cls.equals(BigIntegerString.class) && !cls.equals(BigDecimalString.class) && !cls.equals(LocalDate.class) && !cls.equals(OffsetDateTime.class);
    }

    public static SerializedBody serializeRequestBody(Object request, String requestField, String serializationMethod, boolean nullable) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        return RequestBody.serialize(request, requestField, serializationMethod, nullable);
    }

    public static <T> List<QueryParameter> getQueryParams(Class<T> type, Optional<? extends T> params, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        return Utils.getQueryParams(type, params.get(), globals);
    }

    public static <T> List<QueryParameter> getQueryParams(Class<T> type, JsonNullable<? extends T> params, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        if (!params.isPresent() || params.get() == null) {
            return Collections.emptyList();
        }
        return Utils.getQueryParams(type, params.get(), globals);
    }

    public static <T> List<QueryParameter> getQueryParams(Class<T> type, T params, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        return QueryParameters.parseQueryParams(type, params, globals);
    }

    public static HTTPRequest configureSecurity(HTTPRequest request, Object security) throws Exception {
        return Security.configureSecurity(request, security);
    }

    public static String templateUrl(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("(\\{.*?\\})");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String match = m.group(1);
            String key = match.substring(1, match.length() - 1);
            String value = params.get(key);
            if (value == null) continue;
            m.appendReplacement(sb, value.replace("$", DOLLAR_MARKER));
        }
        m.appendTail(sb);
        return sb.toString().replace(DOLLAR_MARKER, "$");
    }

    public static Map<String, List<String>> getHeadersFromMetadata(Object headers, Map<String, Map<String, Map<String, Object>>> globals) throws Exception {
        Field[] fields;
        if (headers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        block5: for (Field field : fields = headers.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            HeaderMetadata headerMetadata = HeaderMetadata.parse(field);
            if (headerMetadata == null) continue;
            Object value = field.get(headers);
            value = Utils.resolveOptionals(value);
            if ((value = Utils.populateGlobal(value, field.getName(), "header", globals)) == null) continue;
            switch (Types.getType(value.getClass())) {
                case OBJECT: {
                    Field[] valueFields;
                    if (!Utils.allowIntrospection(value.getClass())) continue block5;
                    ArrayList<String> items = new ArrayList<String>();
                    for (Field valueField : valueFields = value.getClass().getDeclaredFields()) {
                        valueField.setAccessible(true);
                        HeaderMetadata valueHeaderMetadata = HeaderMetadata.parse(valueField);
                        if (valueHeaderMetadata == null || valueHeaderMetadata.name == null || valueHeaderMetadata.name.isBlank()) continue;
                        Object valueFieldValue = valueField.get(value);
                        if ((valueFieldValue = Utils.resolveOptionals(valueFieldValue)) == null) continue;
                        if (headerMetadata.explode) {
                            items.add(String.format("%s=%s", valueHeaderMetadata.name, Utils.valToString(valueFieldValue)));
                            continue;
                        }
                        items.add(valueHeaderMetadata.name);
                        items.add(Utils.valToString(valueFieldValue));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                case MAP: {
                    Map map = (Map)value;
                    if (map.size() == 0) continue block5;
                    ArrayList<String> items = new ArrayList<String>();
                    for (Map.Entry entry : map.entrySet()) {
                        if (headerMetadata.explode) {
                            items.add(String.format("%s=%s", Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                            continue;
                        }
                        items.add(Utils.valToString(entry.getKey()));
                        items.add(Utils.valToString(entry.getValue()));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                case ARRAY: {
                    List<Object> array = Utils.toList(value);
                    if (array.isEmpty()) continue block5;
                    ArrayList<String> items = new ArrayList();
                    for (Object object : array) {
                        items.add(Utils.valToString(object));
                    }
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    Object values = (List)result.get(headerMetadata.name);
                    values.add(String.join((CharSequence)",", items));
                    continue block5;
                }
                default: {
                    if (!result.containsKey(headerMetadata.name)) {
                        result.put(headerMetadata.name, new ArrayList());
                    }
                    List values = (List)result.get(headerMetadata.name);
                    values.add(Utils.valToString(value));
                    continue block5;
                }
            }
        }
        return result;
    }

    public static String valToString(Object value) {
        if (value.getClass().isEnum()) {
            try {
                Field field = value.getClass().getDeclaredField("value");
                field.setAccessible(true);
                return String.valueOf(field.get(value));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                return "ERROR_UNKNOWN_VALUE";
            }
        }
        return String.valueOf(Utils.resolveOptionals(value));
    }

    public static String prefixBearer(String authHeaderValue) {
        if (authHeaderValue.toLowerCase().startsWith("bearer ")) {
            return authHeaderValue;
        }
        return "Bearer " + authHeaderValue;
    }

    public static Object populateGlobal(Object value, String fieldName, String paramType, Map<String, Map<String, Map<String, Object>>> globals) {
        Object globalVal;
        if (value == null && globals != null && globals.containsKey("parameters") && globals.get("parameters").containsKey(paramType) && (globalVal = globals.get("parameters").get(paramType).get(fieldName)) != null) {
            value = globalVal;
        }
        return value;
    }

    private static Map<String, String> parseSerializedParams(PathParamsMetadata pathParamsMetadata, Object value) throws JsonProcessingException {
        HashMap<String, String> params = new HashMap<String, String>();
        switch (pathParamsMetadata.serialization) {
            case "json": {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(value);
                params.put(pathParamsMetadata.name, Utils.pathEncode(json, pathParamsMetadata.allowReserved));
                break;
            }
        }
        return params;
    }

    public static <T> T checkNotNull(T object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return object;
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <K, V> Map<K, V> emptyMapIfNull(Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    public static String toString(Class<?> cls, Object ... items) {
        if (items.length % 2 != 0) {
            throw new IllegalArgumentException("items must have an even length");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < items.length; i += 2) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(items[i]);
            s.append("=");
            s.append(items[i + 1]);
        }
        return cls.getSimpleName() + "[" + s + "]";
    }

    public static Object resolveOptionals(Object o) {
        if (o instanceof Optional) {
            return ((Optional)o).orElse(null);
        }
        if (o instanceof JsonNullable) {
            return ((JsonNullable)o).orElse(null);
        }
        return o;
    }

    public static List<?> toList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o.getClass().isArray()) {
            return Arrays.asList((Object[])o);
        }
        throw new IllegalArgumentException("argument must be List or array");
    }

    public static <T> T readDefaultOrConstValue(String name, String json, TypeReference<T> typeReference) {
        try {
            return Utils.readValue(json, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("default/const value did not match the expected type, name=" + name + ",json=\n" + json, e);
        }
    }

    private static <T> T readValue(String json, TypeReference<T> typeReference) throws JsonProcessingException {
        return (T)JSON.getMapper().readValue(json, typeReference);
    }

    public static byte[] extractByteArrayFromBody(HttpResponse<InputStream> response) throws IOException {
        return Utils.toByteArrayAndClose(response.body());
    }

    public static byte[] toByteArrayAndClose(InputStream in) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String toUtf8AndClose(InputStream in) throws IOException {
        return new String(Utils.toByteArrayAndClose(in), StandardCharsets.UTF_8);
    }

    public static Object convertToShape(Object o, JsonShape shape, TypeReference<?> typeReference) {
        if (shape == JsonShape.STRING) {
            return Utils.convertToStringShape(o, typeReference);
        }
        return o;
    }

    private static Object convertToStringShape(Object o, TypeReference<?> typeReference) {
        JavaType jt = JSON.getMapper().getTypeFactory().resolveMemberType(typeReference.getType(), null);
        return Utils.convertToStringShape(o, jt);
    }

    private static Object convertToStringShape(Object o, JavaType jt) {
        if (jt.getRawClass().equals(List.class)) {
            List list = (List)o;
            return list.stream().map(x -> Utils.convertToStringShape(x, jt.getContentType())).collect(Collectors.toList());
        }
        if (jt.getRawClass().equals(Map.class)) {
            Map map = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), Utils.convertToStringShape(entry.getValue(), jt.getContentType()));
            }
            return result;
        }
        if (jt.getRawClass().equals(Optional.class)) {
            Optional optional = (Optional)o;
            if (optional.isPresent()) {
                return Optional.of(Utils.convertToStringShape(optional.get(), jt.getContentType()));
            }
            return o;
        }
        if (jt.getRawClass().equals(JsonNullable.class)) {
            JsonNullable n = (JsonNullable)o;
            if (n.isPresent()) {
                if (n.get() == null) {
                    return o;
                }
                return JsonNullable.of((Object)Utils.convertToStringShape(n.get(), jt.getContentType()));
            }
            return o;
        }
        if (STRING_CONVERSIONS.containsKey(jt.getRawClass())) {
            return STRING_CONVERSIONS.get(jt.getRawClass()).apply(o);
        }
        return o;
    }

    private static Object convertToStringShapeInverse(Object o, JavaType jt) {
        if (jt.getRawClass().equals(List.class)) {
            List list = (List)o;
            return list.stream().map(x -> Utils.convertToStringShapeInverse(x, jt.getContentType())).collect(Collectors.toList());
        }
        if (jt.getRawClass().equals(Map.class)) {
            Map map = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), Utils.convertToStringShapeInverse(entry.getValue(), jt.getContentType()));
            }
            return result;
        }
        if (jt.getRawClass().equals(Optional.class)) {
            Optional optional = (Optional)o;
            if (optional.isPresent()) {
                return Optional.of(Utils.convertToStringShapeInverse(optional.get(), jt.getContentType()));
            }
            return o;
        }
        if (jt.getRawClass().equals(JsonNullable.class)) {
            JsonNullable n = (JsonNullable)o;
            if (n.isPresent()) {
                if (n.get() == null) {
                    return o;
                }
                return JsonNullable.of((Object)Utils.convertToStringShapeInverse(n.get(), jt.getContentType()));
            }
            return o;
        }
        if (STRING_INVERSE_CONVERSIONS.containsKey(jt.getRawClass())) {
            return STRING_INVERSE_CONVERSIONS.get(jt.getRawClass()).apply(o);
        }
        return o;
    }

    static JavaType convertToShape(TypeFactory f, TypeReference<?> typeReference, JsonShape shape) {
        JavaType jt = f.resolveMemberType(typeReference.getType(), null);
        if (shape == JsonShape.STRING) {
            return Utils.convertToStringShape(f, jt);
        }
        return jt;
    }

    static Object convertToShapeInverse(Object o, JsonShape shape, JavaType jt) {
        if (shape == JsonShape.STRING) {
            return Utils.convertToStringShapeInverse(o, jt);
        }
        return o;
    }

    public static JavaType convertToStringShape(TypeFactory f, JavaType a) {
        if (a.getRawClass().equals(List.class)) {
            JavaType b = Utils.convertToStringShape(f, a.getContentType());
            return f.constructCollectionType(List.class, b);
        }
        if (a.getRawClass().equals(Map.class)) {
            JavaType key = f.constructType(String.class);
            JavaType value = Utils.convertToStringShape(f, a.getContentType());
            return f.constructMapType(Map.class, key, value);
        }
        if (a.getRawClass().equals(Optional.class)) {
            JavaType b = Utils.convertToStringShape(f, a.getContentType());
            return f.constructParametricType(Optional.class, new JavaType[]{b});
        }
        if (a.getRawClass().equals(JsonNullable.class)) {
            JavaType b = Utils.convertToStringShape(f, a.getContentType());
            return f.constructParametricType(JsonNullable.class, new JavaType[]{b});
        }
        if (a.getRawClass().equals(BigInteger.class)) {
            return f.constructType(BigIntegerString.class);
        }
        if (a.getRawClass().equals(BigDecimal.class)) {
            return f.constructType(BigDecimalString.class);
        }
        return a;
    }

    static <T> Object resolveStringShape(Class<T> type, String fieldName, Object value) throws IllegalAccessException {
        try {
            Field tr = type.getDeclaredField(fieldName + "_typeReference");
            tr.setAccessible(true);
            TypeReference typeReference = (TypeReference)tr.get(null);
            return Utils.convertToShape(value, JsonShape.STRING, typeReference);
        }
        catch (NoSuchFieldException e) {
            return value;
        }
    }

    public static <T> Stream<T> stream(Callable<Optional<T>> first, Function<T, Optional<T>> next) {
        return StreamSupport.stream(Utils.iterable(first, next).spliterator(), false);
    }

    private static <T> Iterable<T> iterable(final Callable<Optional<T>> first, final Function<T, Optional<T>> next) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private boolean pending = true;
                    private Optional<T> nxt;

                    @Override
                    public boolean hasNext() {
                        this.load();
                        return this.nxt.isPresent();
                    }

                    @Override
                    public T next() {
                        this.load();
                        if (!this.nxt.isPresent()) {
                            throw new NoSuchElementException();
                        }
                        this.pending = true;
                        return this.nxt.get();
                    }

                    private void load() {
                        try {
                            if (this.pending) {
                                if (this.nxt == null) {
                                    this.nxt = (Optional)first.call();
                                } else if (this.nxt.isPresent()) {
                                    this.nxt = (Optional)next.apply(this.nxt.get());
                                }
                                this.pending = false;
                            }
                        }
                        catch (Exception e) {
                            Utils.rethrow(e);
                        }
                    }
                };
            }
        };
    }

    private static <T> T rethrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean statusCodeMatches(int statusCode, String ... expectedStatusCodes) {
        return Arrays.stream(expectedStatusCodes).anyMatch(expected -> Utils.statusCodeMatchesOne(statusCode, expected));
    }

    public static boolean statusCodeMatchesOne(int statusCode, String expectedStatusCode) {
        String firstDigitExpected;
        Utils.checkNotNull(expectedStatusCode, "expectedStatusCode");
        if (expectedStatusCode.toLowerCase(Locale.ENGLISH).equals("default")) {
            return true;
        }
        if (statusCode < 100 || statusCode >= 600) {
            throw new IllegalArgumentException("unexpected http status code: " + statusCode);
        }
        if (expectedStatusCode.length() != 3) {
            return false;
        }
        String firstDigit = String.valueOf(statusCode / 100);
        if (!firstDigit.equals(firstDigitExpected = expectedStatusCode.substring(0, 1))) {
            return false;
        }
        if (expectedStatusCode.toUpperCase(Locale.ENGLISH).endsWith("XX")) {
            return true;
        }
        return expectedStatusCode.equals(String.valueOf(statusCode));
    }

    public static HttpRequest.Builder copy(HttpRequest request) {
        return Utils.copy(request, (k, v) -> true);
    }

    public static HttpRequest.Builder copy(HttpRequest request, BiPredicate<String, String> filter) {
        Utils.checkNotNull(request, "request");
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(request.uri());
        builder.expectContinue(request.expectContinue());
        request.headers().map().forEach((name, values) -> values.stream().filter(v -> filter.test((String)name, (String)v)).forEach(value -> builder.header((String)name, (String)value)));
        request.version().ifPresent(builder::version);
        request.timeout().ifPresent(builder::timeout);
        String method = request.method();
        request.bodyPublisher().ifPresentOrElse(bodyPublisher -> builder.method(method, (HttpRequest.BodyPublisher)bodyPublisher), () -> {
            switch (method) {
                case "GET": {
                    builder.GET();
                    break;
                }
                case "DELETE": {
                    builder.DELETE();
                    break;
                }
                default: {
                    builder.method(method, HttpRequest.BodyPublishers.noBody());
                }
            }
        });
        return builder;
    }

    public static ObjectMapper mapper() {
        return JSON.getMapper();
    }

    public static <T> T asType(EventStreamMessage x, ObjectMapper mapper, TypeReference<T> typeReference) {
        try {
            String json = Utils.json(x, mapper, false);
            return (T)mapper.readValue(json, typeReference);
        }
        catch (JsonProcessingException e) {
            try {
                String json = Utils.json(x, mapper, true);
                return (T)mapper.readValue(json, typeReference);
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static String json(EventStreamMessage m, ObjectMapper mapper, boolean dataIsPlainText) throws JsonProcessingException {
        ObjectNode node = mapper.createObjectNode();
        m.event().ifPresent(value -> node.set("event", (JsonNode)new TextNode(value)));
        m.id().ifPresent(value -> node.set("id", (JsonNode)new TextNode(value)));
        m.retryMs().ifPresent(value -> node.set("retry", (JsonNode)new IntNode(value.intValue())));
        if (dataIsPlainText || m.data().trim().isEmpty()) {
            node.set("data", (JsonNode)new TextNode(m.data()));
        } else {
            JsonNode tree = mapper.readTree(m.data());
            node.set("data", tree);
        }
        return mapper.writeValueAsString((Object)node);
    }

    public static HttpResponseCached cache(HttpResponse<InputStream> response) throws IOException {
        return new HttpResponseCached(response);
    }

    public static String bytesToLowerCaseHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String discriminatorToString(Object o) {
        Class<?> cls = o.getClass();
        if (cls.equals(Optional.class)) {
            Optional a = (Optional)o;
            return a.map(x -> Utils.discriminatorToString(x)).orElse(null);
        }
        if (cls.isEnum()) {
            try {
                Method m = cls.getMethod("value", new Class[0]);
                return (String)m.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return (String)o;
    }

    public static void recordTest(String id) {
        try {
            new File("build").mkdir();
            Files.writeString(Paths.get("build/test-javav2-record.txt", new String[0]), (CharSequence)(id + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String sortQueryParameters(String url) {
        if (url == null || url.isBlank()) {
            return "";
        }
        String[] parts = url.split("\\?");
        if (parts.length == 1) {
            return url;
        }
        String query = parts[1];
        String[] params = query.split("&");
        Utils.sortByDelimitedKey(params, "=");
        return parts[0] + "?" + Arrays.stream(params).collect(Collectors.joining("&"));
    }

    public static Object sortSerializedMaps(Object input, String regex, String delim) {
        if (input == null) {
            return input;
        }
        if (input instanceof String) {
            return Utils.sortMapString((String)input, regex, delim);
        }
        if (input.getClass().isArray()) {
            Object[] a = (Object[])input;
            String[] b = new String[a.length];
            for (int i = 0; i < a.length; ++i) {
                if (!(a[i] instanceof String)) {
                    throw new IllegalArgumentException("expected array item type of String, found " + a[i]);
                }
                b[i] = Utils.sortMapString((String)a[i], regex, delim);
            }
            return b;
        }
        if (input instanceof Map) {
            Map a = (Map)input;
            LinkedHashMap<String, String> b = new LinkedHashMap<String, String>();
            for (Map.Entry entry : a.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("expected map key type of String, found " + entry.getKey());
                }
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalArgumentException("expected map value type of String, found " + entry.getValue());
                }
                b.put((String)entry.getKey(), Utils.sortMapString((String)entry.getValue(), regex, delim));
            }
            return b;
        }
        throw new IllegalArgumentException("unexpected type: " + input.getClass());
    }

    private static String sortMapString(String input, String regex, String delim) {
        return Pattern.compile(regex).matcher(input).replaceAll(m -> {
            String escapedDelim = Pattern.quote(delim);
            String result = m.group();
            for (int i = 1; i <= m.groupCount(); ++i) {
                String[] pairs;
                String match = m.group(i);
                if (match.contains("=")) {
                    pairs = match.split(escapedDelim);
                    Utils.sortByDelimitedKey(pairs, "=");
                } else {
                    String[] values = match.split(escapedDelim);
                    if (values.length == 1) {
                        pairs = values;
                    } else {
                        pairs = new String[values.length / 2];
                        for (int j = 0; j < values.length; j += 2) {
                            pairs[j / 2] = values[j] + delim + values[j + 1];
                        }
                    }
                    Utils.sortByDelimitedKey(pairs, delim);
                }
                String joined = Arrays.stream(pairs).collect(Collectors.joining(delim));
                result = result.replace(m.group(i), joined);
            }
            return result;
        });
    }

    private static void sortByDelimitedKey(String[] array, String delim) {
        Arrays.sort(array, (a, b) -> {
            String escapedDelim = Pattern.quote(delim);
            String aKey = a.split(escapedDelim)[0];
            String bKey = b.split(escapedDelim)[0];
            return aKey.compareTo(bKey);
        });
    }

    public static boolean isPresentAndNotNull(Optional<?> x) {
        return x.isPresent();
    }

    public static boolean isPresentAndNotNull(JsonNullable<?> x) {
        return x.isPresent() && x.get() != null;
    }

    public static void setSseSentinel(Object o, String value) {
        if (o == null || value.isBlank()) {
            return;
        }
        try {
            Field field = o.getClass().getDeclaredField("_eventSentinel");
            field.setAccessible(true);
            field.set(o, Optional.of(value));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }

    public static final class HttpResponseCached
    implements HttpResponse<InputStream> {
        private final HttpResponse<InputStream> response;
        private final byte[] bytes;

        public HttpResponseCached(HttpResponse<InputStream> response) throws IOException {
            this.response = response;
            this.bytes = Utils.toByteArrayAndClose(response.body());
        }

        public String bodyAsUtf8() {
            return new String(this.bytes, StandardCharsets.UTF_8);
        }

        public byte[] bodyAsBytes() {
            return this.bytes;
        }

        @Override
        public int statusCode() {
            return this.response.statusCode();
        }

        @Override
        public HttpRequest request() {
            return this.response.request();
        }

        @Override
        public Optional<HttpResponse<InputStream>> previousResponse() {
            return this.response.previousResponse();
        }

        @Override
        public HttpHeaders headers() {
            return this.response.headers();
        }

        @Override
        public InputStream body() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Optional<SSLSession> sslSession() {
            return this.response.sslSession();
        }

        @Override
        public URI uri() {
            return this.response.uri();
        }

        @Override
        public HttpClient.Version version() {
            return this.response.version();
        }

        public String toString() {
            return this.response.toString();
        }
    }

    public static interface Function<S, T> {
        public T apply(S var1) throws Exception;
    }

    public static final class TypeReferenceWithShape {
        private final TypeReference<?> typeReference;
        private final JsonShape shape;

        private TypeReferenceWithShape(TypeReference<?> typeReference, JsonShape shape) {
            this.typeReference = typeReference;
            this.shape = shape;
        }

        public static TypeReferenceWithShape of(TypeReference<?> typeReference, JsonShape shape) {
            return new TypeReferenceWithShape(typeReference, shape);
        }

        public TypeReference<?> typeReference() {
            return this.typeReference;
        }

        public JsonShape shape() {
            return this.shape;
        }
    }

    public static enum JsonShape {
        STRING,
        DEFAULT;

    }
}

