/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.prove.proveapi.utils.Utils;
import java.io.IOException;

@JsonSerialize(using=Serializer.class)
public class TypedObject {
    private final Object value;
    private final TypeReference<?> typeReference;
    private final Utils.JsonShape shape;

    private TypedObject(Object value, Utils.JsonShape shape, TypeReference<?> typeReference) {
        this.value = value;
        this.shape = shape;
        this.typeReference = typeReference;
    }

    public Object value() {
        return this.value;
    }

    public TypeReference<?> typeReference() {
        return this.typeReference;
    }

    public Utils.JsonShape shape() {
        return this.shape;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static <T> TypedObject of(T value, Utils.JsonShape shape, TypeReference<T> typeReference) {
        return new TypedObject(value, shape, typeReference);
    }

    public static final class Serializer
    extends StdSerializer<TypedObject> {
        private static final long serialVersionUID = -1L;

        public Serializer() {
            super(TypedObject.class);
        }

        public void serialize(TypedObject value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Object o = Utils.convertToShape(value.value(), value.shape(), value.typeReference());
            provider.defaultSerializeValue(o, gen);
        }
    }
}

