/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3ChallengeResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3ChallengeRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3ChallengeResponse> v3ChallengeResponse;

    @JsonCreator
    public V3ChallengeRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3ChallengeResponse> v3ChallengeResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3ChallengeResponse, "v3ChallengeResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3ChallengeResponse = v3ChallengeResponse;
    }

    public V3ChallengeRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3ChallengeResponse> v3ChallengeResponse() {
        return this.v3ChallengeResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ChallengeRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3ChallengeRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3ChallengeRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3ChallengeRequestResponse withV3ChallengeResponse(V3ChallengeResponse v3ChallengeResponse) {
        Utils.checkNotNull(v3ChallengeResponse, "v3ChallengeResponse");
        this.v3ChallengeResponse = Optional.ofNullable(v3ChallengeResponse);
        return this;
    }

    public V3ChallengeRequestResponse withV3ChallengeResponse(Optional<? extends V3ChallengeResponse> v3ChallengeResponse) {
        Utils.checkNotNull(v3ChallengeResponse, "v3ChallengeResponse");
        this.v3ChallengeResponse = v3ChallengeResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ChallengeRequestResponse other = (V3ChallengeRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3ChallengeResponse, other.v3ChallengeResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3ChallengeResponse);
    }

    public String toString() {
        return Utils.toString(V3ChallengeRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3ChallengeResponse", this.v3ChallengeResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3ChallengeResponse> v3ChallengeResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3ChallengeResponse(V3ChallengeResponse v3ChallengeResponse) {
            Utils.checkNotNull(v3ChallengeResponse, "v3ChallengeResponse");
            this.v3ChallengeResponse = Optional.ofNullable(v3ChallengeResponse);
            return this;
        }

        public Builder v3ChallengeResponse(Optional<? extends V3ChallengeResponse> v3ChallengeResponse) {
            Utils.checkNotNull(v3ChallengeResponse, "v3ChallengeResponse");
            this.v3ChallengeResponse = v3ChallengeResponse;
            return this;
        }

        public V3ChallengeRequestResponse build() {
            return new V3ChallengeRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3ChallengeResponse);
        }
    }
}

