/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.utils.SpeakeasyMetadata;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;

public class V3TokenRequest {
    @SpeakeasyMetadata(value="form:name=client_id")
    private String clientId;
    @SpeakeasyMetadata(value="form:name=client_secret")
    private String clientSecret;
    @SpeakeasyMetadata(value="form:name=grant_type")
    private String grantType;

    @JsonCreator
    public V3TokenRequest(String clientId, String clientSecret, String grantType) {
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(clientSecret, "clientSecret");
        Utils.checkNotNull(grantType, "grantType");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.grantType = grantType;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String clientSecret() {
        return this.clientSecret;
    }

    @JsonIgnore
    public String grantType() {
        return this.grantType;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3TokenRequest withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public V3TokenRequest withClientSecret(String clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }

    public V3TokenRequest withGrantType(String grantType) {
        Utils.checkNotNull(grantType, "grantType");
        this.grantType = grantType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3TokenRequest other = (V3TokenRequest)o;
        return Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.clientSecret, other.clientSecret) && Objects.deepEquals(this.grantType, other.grantType);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.grantType);
    }

    public String toString() {
        return Utils.toString(V3TokenRequest.class, "clientId", this.clientId, "clientSecret", this.clientSecret, "grantType", this.grantType);
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private String grantType;

        private Builder() {
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder grantType(String grantType) {
            Utils.checkNotNull(grantType, "grantType");
            this.grantType = grantType;
            return this;
        }

        public V3TokenRequest build() {
            return new V3TokenRequest(this.clientId, this.clientSecret, this.grantType);
        }
    }
}

