/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.V3CompleteIndividualRequest;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;

public class V3CompleteRequest {
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonProperty(value="individual")
    private V3CompleteIndividualRequest individual;

    @JsonCreator
    public V3CompleteRequest(@JsonProperty(value="correlationId") String correlationId, @JsonProperty(value="individual") V3CompleteIndividualRequest individual) {
        Utils.checkNotNull(correlationId, "correlationId");
        Utils.checkNotNull(individual, "individual");
        this.correlationId = correlationId;
        this.individual = individual;
    }

    @JsonIgnore
    public String correlationId() {
        return this.correlationId;
    }

    @JsonIgnore
    public V3CompleteIndividualRequest individual() {
        return this.individual;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3CompleteRequest withCorrelationId(String correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = correlationId;
        return this;
    }

    public V3CompleteRequest withIndividual(V3CompleteIndividualRequest individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = individual;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3CompleteRequest other = (V3CompleteRequest)o;
        return Objects.deepEquals(this.correlationId, other.correlationId) && Objects.deepEquals(this.individual, other.individual);
    }

    public int hashCode() {
        return Objects.hash(this.correlationId, this.individual);
    }

    public String toString() {
        return Utils.toString(V3CompleteRequest.class, "correlationId", this.correlationId, "individual", this.individual);
    }

    public static final class Builder {
        private String correlationId;
        private V3CompleteIndividualRequest individual;

        private Builder() {
        }

        public Builder correlationId(String correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = correlationId;
            return this;
        }

        public Builder individual(V3CompleteIndividualRequest individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = individual;
            return this;
        }

        public V3CompleteRequest build() {
            return new V3CompleteRequest(this.correlationId, this.individual);
        }
    }
}

