/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.prove.proveapi.utils.LazySingletonValue;
import com.prove.proveapi.utils.SpeakeasyMetadata;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class Security {
    @SpeakeasyMetadata(value="security:scheme=true,type=oauth2,subtype=client_credentials,name=clientID")
    private Optional<String> clientID;
    @SpeakeasyMetadata(value="security:scheme=true,type=oauth2,subtype=client_credentials,name=clientSecret")
    private Optional<String> clientSecret;
    private Optional<String> tokenURL;

    @JsonCreator
    public Security(Optional<String> clientID, Optional<String> clientSecret, Optional<String> tokenURL) {
        Utils.checkNotNull(clientID, "clientID");
        Utils.checkNotNull(clientSecret, "clientSecret");
        Utils.checkNotNull(tokenURL, "tokenURL");
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.tokenURL = tokenURL;
    }

    public Security() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> clientID() {
        return this.clientID;
    }

    @JsonIgnore
    public Optional<String> clientSecret() {
        return this.clientSecret;
    }

    @JsonIgnore
    public Optional<String> tokenURL() {
        return this.tokenURL;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Security withClientID(String clientID) {
        Utils.checkNotNull(clientID, "clientID");
        this.clientID = Optional.ofNullable(clientID);
        return this;
    }

    public Security withClientID(Optional<String> clientID) {
        Utils.checkNotNull(clientID, "clientID");
        this.clientID = clientID;
        return this;
    }

    public Security withClientSecret(String clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = Optional.ofNullable(clientSecret);
        return this;
    }

    public Security withClientSecret(Optional<String> clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }

    public Security withTokenURL(String tokenURL) {
        Utils.checkNotNull(tokenURL, "tokenURL");
        this.tokenURL = Optional.ofNullable(tokenURL);
        return this;
    }

    public Security withTokenURL(Optional<String> tokenURL) {
        Utils.checkNotNull(tokenURL, "tokenURL");
        this.tokenURL = tokenURL;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security)o;
        return Objects.deepEquals(this.clientID, other.clientID) && Objects.deepEquals(this.clientSecret, other.clientSecret) && Objects.deepEquals(this.tokenURL, other.tokenURL);
    }

    public int hashCode() {
        return Objects.hash(this.clientID, this.clientSecret, this.tokenURL);
    }

    public String toString() {
        return Utils.toString(Security.class, "clientID", this.clientID, "clientSecret", this.clientSecret, "tokenURL", this.tokenURL);
    }

    public static final class Builder {
        private Optional<String> clientID = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        private Optional<String> tokenURL;
        private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_TokenURL = new LazySingletonValue<Optional<String>>("TokenURL", "\"/token\"", new TypeReference<Optional<String>>(){});

        private Builder() {
        }

        public Builder clientID(String clientID) {
            Utils.checkNotNull(clientID, "clientID");
            this.clientID = Optional.ofNullable(clientID);
            return this;
        }

        public Builder clientID(Optional<String> clientID) {
            Utils.checkNotNull(clientID, "clientID");
            this.clientID = clientID;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        public Builder clientSecret(Optional<String> clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder tokenURL(String tokenURL) {
            Utils.checkNotNull(tokenURL, "tokenURL");
            this.tokenURL = Optional.ofNullable(tokenURL);
            return this;
        }

        public Builder tokenURL(Optional<String> tokenURL) {
            Utils.checkNotNull(tokenURL, "tokenURL");
            this.tokenURL = tokenURL;
            return this;
        }

        public Security build() {
            if (this.tokenURL == null) {
                this.tokenURL = _SINGLETON_VALUE_TokenURL.value();
            }
            return new Security(this.clientID, this.clientSecret, this.tokenURL);
        }
    }
}

