/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.hooks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.SecuritySource;
import com.prove.proveapi.models.errors.AuthException;
import com.prove.proveapi.utils.HTTPClient;
import com.prove.proveapi.utils.Helpers;
import com.prove.proveapi.utils.Hook;
import com.prove.proveapi.utils.RequestBody;
import com.prove.proveapi.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ClientCredentialsHook
implements Hook.SdkInit,
Hook.BeforeRequest,
Hook.AfterError {
    static final int REFRESH_BEFORE_EXPIRY_SECONDS = 60;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private String baseUrl;
    private HTTPClient client;

    @Override
    public Hook.SdkInitData sdkInit(Hook.SdkInitData data) {
        this.baseUrl = data.baseUrl();
        this.client = data.client();
        return new Hook.SdkInitData(this.baseUrl, this.client);
    }

    @Override
    public HttpRequest beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) throws Exception {
        Session session;
        if (!context.oauthScopes().isPresent()) {
            return request;
        }
        Optional<Credentials> c = ClientCredentialsHook.credentials(context.securitySource());
        if (!c.isPresent()) {
            return request;
        }
        Credentials credentials = c.get();
        String sessionKey = ClientCredentialsHook.sessionKey(credentials);
        Optional<Session> currentSession = Optional.ofNullable(this.sessions.get(sessionKey));
        if (ClientCredentialsHook.shouldCreateNewSession(currentSession, context.oauthScopes())) {
            List<String> scopes = ClientCredentialsHook.accumulateScopes(context.oauthScopes(), currentSession);
            session = ClientCredentialsHook.doTokenRequest(this.baseUrl, this.client, credentials, scopes);
            this.sessions.put(sessionKey, session);
        } else {
            session = currentSession.get();
        }
        return Helpers.copy(request).setHeader("Authorization", "Bearer " + session.token.orElse("")).build();
    }

    static boolean shouldCreateNewSession(Optional<Session> currentSession, Optional<List<String>> oauthScopes) {
        return !currentSession.isPresent() || !ClientCredentialsHook.hasRequiredScopes(currentSession.get().scopes, oauthScopes) || ClientCredentialsHook.hasTokenExpired(currentSession.get().expiresAt, OffsetDateTime.now());
    }

    @Override
    public HttpResponse<InputStream> afterError(Hook.AfterErrorContext context, Optional<HttpResponse<InputStream>> response, Optional<Exception> error) throws Exception {
        if (error.isPresent()) {
            throw error.get();
        }
        if (!context.oauthScopes().isPresent()) {
            return response.get();
        }
        Optional<Credentials> credentials = ClientCredentialsHook.credentials(context.securitySource());
        if (!credentials.isPresent()) {
            return response.get();
        }
        if (response.get().statusCode() == 401) {
            String sessionKey = ClientCredentialsHook.sessionKey(credentials.get());
            this.sessions.remove(sessionKey);
        }
        return response.get();
    }

    private static Session doTokenRequest(String baseUrl, HTTPClient client, Credentials credentials, List<String> scopes) throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, URISyntaxException {
        URI tokenUri;
        HttpRequest request;
        HttpResponse<InputStream> response;
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("grant_type", "client_credentials");
        payload.put("client_id", credentials.clientId);
        payload.put("client_secret", credentials.clientSecret);
        if (scopes.size() > 0) {
            payload.put("scope", scopes.stream().collect(Collectors.joining(" ")));
        }
        if ((response = client.send(request = HttpRequest.newBuilder(tokenUri = URI.create(baseUrl).resolve(credentials.tokenUrl)).header("Content-Type", "application/x-www-form-urlencoded").POST(RequestBody.serializeFormData(payload).body()).build())).statusCode() != 200) {
            String responseBody = Utils.toUtf8AndClose(response.body());
            throw new AuthException(response.statusCode(), "Unexpected status code " + response.statusCode() + ": " + responseBody);
        }
        TokenResponse t = (TokenResponse)Utils.mapper().readValue(response.body(), TokenResponse.class);
        if (!t.tokenType.orElse("").equals("Bearer")) {
            throw new AuthException("Expected 'Bearer' token type but was '" + t.tokenType.orElse("") + "'");
        }
        Optional<OffsetDateTime> expiresAt = t.expiresInMs.map(x -> OffsetDateTime.now().plus((long)x, ChronoUnit.MILLIS));
        return new Session(credentials, t.accessToken, scopes, expiresAt);
    }

    private static List<String> accumulateScopes(Optional<List<String>> requiredScopes, Optional<Session> session) {
        if (session.isPresent()) {
            ArrayList<String> scopes = new ArrayList<String>(requiredScopes.orElse(Collections.emptyList()));
            scopes.addAll(session.get().scopes);
            return scopes.stream().distinct().collect(Collectors.toList());
        }
        return requiredScopes.orElse(Collections.emptyList());
    }

    static boolean hasTokenExpired(Optional<OffsetDateTime> expiresAt, OffsetDateTime now) {
        return expiresAt.isEmpty() || now.plusSeconds(60L).isAfter(expiresAt.get());
    }

    static boolean hasRequiredScopes(List<String> sessionScopes, Optional<List<String>> requiredScopes) {
        return sessionScopes.containsAll(requiredScopes.orElse(Collections.emptyList()));
    }

    private static Optional<Credentials> credentials(Optional<SecuritySource> source) {
        if (!source.isPresent()) {
            return Optional.empty();
        }
        Optional<String> clientId = ClientCredentialsHook.toOptional(source.get().getSecurity().clientID());
        Optional<String> clientSecret = ClientCredentialsHook.toOptional(source.get().getSecurity().clientSecret());
        Optional<String> tokenUrl = ClientCredentialsHook.toOptional(source.get().getSecurity().tokenURL());
        if (clientId.isEmpty() || clientSecret.isEmpty() || tokenUrl.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Credentials(clientId.get(), clientSecret.get(), tokenUrl.get()));
    }

    private static Optional<String> toOptional(String s) {
        return Optional.ofNullable(s);
    }

    private static Optional<String> toOptional(Optional<String> s) {
        return s;
    }

    private static String sessionKey(Credentials credentials) {
        return ClientCredentialsHook.sessionKey(credentials.clientId, credentials.clientSecret);
    }

    private static String sessionKey(String clientId, String clientSecret) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String input = clientId + ":" + clientSecret;
            byte[] bytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
            return Utils.bytesToLowerCaseHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static final class Session {
        final Credentials credentials;
        final Optional<String> token;
        final List<String> scopes;
        final Optional<OffsetDateTime> expiresAt;

        Session(Credentials credentials, Optional<String> token, List<String> scopes, Optional<OffsetDateTime> expiresAt) {
            this.credentials = credentials;
            this.token = token;
            this.scopes = scopes;
            this.expiresAt = expiresAt;
        }
    }

    static final class Credentials {
        final String clientId;
        final String clientSecret;
        final String tokenUrl;

        Credentials(String clientId, String clientSecret, String tokenUrl) {
            Utils.checkNotNull(clientId, "clientId");
            Utils.checkNotNull(clientSecret, "clientSecret");
            Utils.checkNotNull(tokenUrl, "tokenUrl");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.tokenUrl = tokenUrl;
        }
    }

    static final class TokenResponse {
        @JsonProperty(value="access_token")
        Optional<String> accessToken;
        @JsonProperty(value="token_type")
        Optional<String> tokenType;
        @JsonProperty(value="expires_in")
        Optional<Long> expiresInMs;

        TokenResponse() {
        }
    }
}

